
#include "defs.h"

#include "mainwnd.h"

static gboolean log_message_box(gpointer data, gint type, gchar *msg)
{
    static gboolean active = FALSE;
    GtkWidget *dialog;
    GtkWindow *parent;

    if(active)
        return FALSE;

    active  = TRUE;
    parent = GTK_WINDOW(gtk_grab_get_current());
    if(parent == NULL) parent = mainwnd_get_wnd();

    dialog = gtk_message_dialog_new(parent, GTK_DIALOG_DESTROY_WITH_PARENT, type, GTK_BUTTONS_OK, "%s", msg);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
    g_free(msg);
    active  = FALSE;
    return FALSE;
}

gboolean log_show_message(gpointer data)
{
    return log_message_box(data, GTK_MESSAGE_INFO, (gchar*)data);
}

gboolean log_show_warning(gpointer data)
{
    return log_message_box(data, GTK_MESSAGE_WARNING, (gchar*)data);
}

gboolean log_show_error(gpointer data)
{
    return log_message_box(data, GTK_MESSAGE_ERROR, (gchar*)data);
}

void log_message(char *message)
{
    g_idle_add(log_show_message, (gpointer)g_strdup(message));
}

void log_warning(char *message)
{
    g_idle_add(log_show_warning, (gpointer)g_strdup(message));
}

void log_error(char *message)
{
    g_idle_add(log_show_error, (gpointer)g_strdup(message));
}

void log_func(const gchar *file, gint line, LOG_LEVEL level, const gchar *message, ...)
{
    va_list ap;
    gchar format[1024];
    gchar str[1024];

    switch(level)
    {
    case LOG_ERROR:
        sprintf(format, "%s:%d ERROR : ", file, line);
        break;
    case LOG_CRITICAL:
        sprintf(format, "%s:%d CRITICAL : ", file, line);
        break;
    case LOG_WARNING:
        sprintf(format, "%s:%d WARNING : ", file, line);
        break;
    case LOG_MESSAGE:
        sprintf(format, "%s:%d MESSAGE : ", file, line);
        break;
    case LOG_INFO:
        sprintf(format, "%s:%d INFO : ", file, line);
        break;
    }

    va_start(ap, message);
    vsprintf(str, message, ap);
    va_end(ap);

#ifndef __OPTIMIZE__
    g_printf("%s\n", str);
#endif

    // Show message box
    if(level <= LOG_MESSAGE)
    {
        switch(level)
        {
        case LOG_ERROR:
        case LOG_CRITICAL:
            log_error(str);
            break;
        case LOG_WARNING:
            log_warning(str);
            break;
        case LOG_MESSAGE:
            log_message(str);
            break;
        default:
            break;
        }
    }
}

