
#include "defs.h"

#include "jcode.h"

gchar *iconv_convert(const gchar *icode, const gchar *ocode, const gchar *orig)
{
    gsize i, o;
    GError *err = NULL;
    return g_convert(orig, strlen(orig), ocode, icode, &i, &o, &err);
}

gboolean is_jis_printable(const guchar *buf)
{
    g_assert(buf != NULL);
    return ((0x21 <= buf[0]) && (buf[0] <= 0x74) && (0x21 <= buf[1]) && (buf[1] <= 0x7E));
}

gboolean is_euc_printable(const guchar *buf)
{
    g_assert(buf != NULL);
    return ((0xA1 <= buf[0]) && (buf[0] <= 0xF4) && (0xA1 <= buf[1]) && (buf[1] <= 0xFE));
}

gboolean validate_euc(gchar *str, gboolean jap_only)
{
    g_strstrip(str);
    if(!strlen(str))
	return False;
    gchar *p = str;
    while(*p)
    {
        if(is_euc_printable((guchar*)p))
	{
            p += 2;
	    continue;
	}
	if(!jap_only)
	{
	    if(isprint(*p))
	    {
		p++;
		continue;
	    }
	    else if(isspace(*p))
	    {
		*p = 0x20;
		p++;
		continue;
	    }
	}
	return False;
    }
    return (p - str);
}

gboolean validate_utf8(const gchar *str, gboolean jap_only)
{
    gchar *euc_str = iconv_convert(ENC_UTF8, ENC_EUC_JP, str);
    gboolean ret = validate_euc(euc_str, jap_only);
    g_free(euc_str);
    return ret;
}

