
#ifndef __HISTORY_H_
#define __HISTORY_H_

#include "builder.h"
#include "prefs.h"

G_BEGIN_DECLS

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

struct _History {
    GObject	    parent_instance;
    GList	    *list;
    Builder	    *builder;
    Prefs	    *prefs;
};

struct _HistoryClass {
    GObjectClass    parent_class;
};

void        history_insert_word(History *self, const gchar *word);
void	    history_insert_res(History *self, RESULT *res);
void        history_prev(gpointer data);

void        history_save_words(History *self);
void        history_load_words(History *self);

RESULT*     history_last_result(History *self);

GType	    history_get_type (void);

G_END_DECLS

void        history_free_data(RESULT *res);

RESULT*     result_new(BOOK_INFO *binfo, EB_Position *pos);
RESULT*     result_duplicate(RESULT *res);
void        result_copy(RESULT *to, RESULT *from);
void        result_free(gpointer data);
void        result_clear_all();
gboolean    result_compare(RESULT *res1, RESULT *res2);

#endif /* __HISTORY_H_ */
