
#ifdef ENABLE_GSTREAMER

#include "defs.h"

#include "ebgstsrc.h"

GST_BOILERPLATE(EbGstSrc, eb_gst_src, GstBaseSrc, GST_TYPE_BASE_SRC);

static GstStaticPadTemplate eb_gst_src_template = GST_STATIC_PAD_TEMPLATE ("src", GST_PAD_SRC, GST_PAD_ALWAYS, GST_STATIC_CAPS_ANY);

static gboolean eb_gst_src_start(GstBaseSrc * basesrc);
static gboolean eb_gst_src_stop(GstBaseSrc * basesrc);
static gboolean eb_gst_src_is_seekable(GstBaseSrc * src);
static gboolean eb_gst_src_query(GstBaseSrc * src, GstQuery * query);
static GstFlowReturn eb_gst_src_create(GstBaseSrc * src, guint64 offset, guint length, GstBuffer ** buffer);

static void eb_gst_src_class_init(EbGstSrcClass *klass)
{
    GObjectClass *gobject_class;
    GstBaseSrcClass *eklass;

    gobject_class = G_OBJECT_CLASS(klass);
    eklass = GST_BASE_SRC_CLASS(klass);

    (void)gobject_class;
    eklass->start = GST_DEBUG_FUNCPTR(eb_gst_src_start);
    eklass->stop = GST_DEBUG_FUNCPTR(eb_gst_src_stop);
    eklass->is_seekable = GST_DEBUG_FUNCPTR(eb_gst_src_is_seekable);
    eklass->create = GST_DEBUG_FUNCPTR(eb_gst_src_create);
    eklass->query = GST_DEBUG_FUNCPTR(eb_gst_src_query);
}

static void eb_gst_src_base_init(gpointer klass)
{
    GstElementClass *gstelement_class = GST_ELEMENT_CLASS(klass);
    gst_element_class_add_pad_template(gstelement_class, gst_static_pad_template_get(&eb_gst_src_template));
}

static void eb_gst_src_init(EbGstSrc *src, EbGstSrcClass * g_class)
{
    src->res = NULL;
}

static gboolean eb_gst_src_start(GstBaseSrc *basesrc)
{
    EB_Error_Code error_code;
    EbGstSrc *src = EB_GST_SRC(basesrc);

    if(!src->res)
	return FALSE;

    gst_base_src_set_blocksize(basesrc, EB_SIZE_PAGE);

    if(!src->res->filename) //audio
    {
	EB_Position endpos;

	endpos.page = src->res->pos.page + (src->res->size / EB_SIZE_PAGE);
	endpos.offset = src->res->pos.offset + (src->res->size % EB_SIZE_PAGE);
	if(EB_SIZE_PAGE <= endpos.offset)
	{
	    endpos.offset -= EB_SIZE_PAGE;
	    endpos.page++;
	}

	error_code = eb_set_binary_wave(src->res->binfo->book, &src->res->pos, &endpos);
	if(error_code != EB_SUCCESS)
	{
	    LOG(LOG_CRITICAL, "Failed to set binary wave: %s", eb_error_message(error_code));
	    return FALSE;
	}
    }
    else // video
    {
	guint argv[4];
	BOOK_INFO *binfo = src->res->binfo;
	if(!binfo)
	    return FALSE;

	error_code = eb_set_subbook(binfo->book, binfo->subbook_no);
	if(error_code != EB_SUCCESS)
	{
	    LOG(LOG_CRITICAL, "Failed to set subbook %s, %d : %s", binfo->path, binfo->subbook_no, eb_error_message(error_code));
	    return FALSE;
	}

	if((error_code = eb_decompose_movie_file_name(argv, src->res->filename)) != EB_SUCCESS)
	    return FALSE;

	error_code = eb_set_binary_mpeg(src->res->binfo->book, argv);
	if(error_code != EB_SUCCESS)
	{
	    LOG(LOG_CRITICAL, "Failed to set binary mpeg: %s", eb_error_message(error_code));
	    return FALSE;
	}
    }

    return TRUE;
}

static gboolean eb_gst_src_stop(GstBaseSrc *basesrc)
{
    return TRUE;
}

static gboolean eb_gst_src_is_seekable(GstBaseSrc *basesrc)
{
    return FALSE;
}

static GstFlowReturn eb_gst_src_create(GstBaseSrc *basesrc, guint64 offset, guint length, GstBuffer **buffer)
{
    ssize_t read_len;
    EB_Error_Code error_code;
    EbGstSrc *src = EB_GST_SRC(basesrc);
    GstBuffer *buf = gst_buffer_try_new_and_alloc(length);
    if(!buf)
	return GST_FLOW_ERROR;

    error_code = eb_read_binary(src->res->binfo->book, EB_SIZE_PAGE, (gchar*)GST_BUFFER_DATA(buf), &read_len);
    if((error_code != EB_SUCCESS) || (read_len == 0))
    {
	gst_buffer_unref(buf);
	return GST_FLOW_UNEXPECTED;
    }
    GST_BUFFER_SIZE(buf) = length;
    GST_BUFFER_OFFSET(buf) = offset;
    GST_BUFFER_OFFSET_END(buf) = offset + length;
    *buffer = buf;

    return GST_FLOW_OK;
}

static gboolean eb_gst_src_query(GstBaseSrc *basesrc, GstQuery * query)
{
    return GST_BASE_SRC_CLASS(parent_class)->query(basesrc, query);
}

#endif

