
#include "defs.h"

#include <locale.h>
#include "dicts.h"
#include "history.h"
#include "hook.h"
#include "mainwnd.h"
#include "prefs.h"
#include "hotkeys.h"

#ifdef ENABLE_GSTREAMER
#include <gst/gst.h>
#endif

gchar* app_browse_disk(gchar* title, GtkWindow *wnd, gint action, gchar *btn_text, gchar *path)
{
    gchar *res = NULL;
    GtkWidget *dlg = gtk_file_chooser_dialog_new(title, wnd, action, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, btn_text, GTK_RESPONSE_ACCEPT, NULL);
    if(path)
    {
        gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dlg), path);
        g_free(path);
    }
    if(gtk_dialog_run(GTK_DIALOG(dlg)) == GTK_RESPONSE_ACCEPT)
        res = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dlg));
    gtk_widget_destroy(dlg);
    return res;
}

int main(int argc, char *argv[])
{
    gtk_init(&argc, &argv);

#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE_NAME, LOCALEDIR);
    bind_textdomain_codeset(PACKAGE_NAME, ENC_UTF8);
    textdomain(PACKAGE_NAME);
#endif

#ifdef ENABLE_GSTREAMER
    gst_init(&argc, &argv);
#endif

    eb_initialize_library();
    hooksets_init();

    Mainwnd *mainwnd = g_object_new(TYPE_MAINWND, NULL);
    mainwnd_prepare(mainwnd);
    gtk_widget_show_all(GTK_WIDGET(mainwnd));

    gtk_main();
    hooksets_finalize();

    _exit(0);
}

