
#ifndef __DUMP_H__
#define __DUMP_H__
    
#include "builder.h"
#include "history.h"

enum
{
    DUMP_HEX,
    DUMP_TEXT,
    DUMP_N
};

G_BEGIN_DECLS   

#define TYPE_DUMP (dump_get_type ())
#define DUMP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUMP, Dump))
#define DUMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUMP, DumpClass))
#define IS_DUMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUMP))
#define IS_DUMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUMP))
#define DUMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUMP, DumpClass))
    
typedef struct _Dump Dump;
typedef struct _DumpClass DumpClass;
    
struct _Dump { 
    GObject         parent_instance;
    Builder         *builder;
    History	    *history;
};

struct _DumpClass {
    GObjectClass    parent_class;
};

void		    dump_hex(Dump *self);
void		    dump_text(Dump *self);
void		    dump_hex_cb(GtkWidget *w, gpointer data);
void		    dump_text_cb(GtkWidget *w, gpointer data);

gboolean	    dump_dlg_visible(Dump *self, gint n);
gboolean	    dump_dlg_show(Dump *self, gint n, gboolean show);

void		    dump_update(Dump *self);

GType               dump_get_type (void);

G_END_DECLS

#endif /* __DUMP_H__ */
