
#ifndef __DICTS_H__
#define __DICTS_H__

#include "builder.h"

G_BEGIN_DECLS

#define TYPE_DICTS (dicts_get_type ())
#define DICTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DICTS, Dicts))
#define DICTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DICTS, DictsClass))
#define IS_DICTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DICTS))
#define IS_DICTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DICTS))
#define DICTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DICTS, DictsClass))

typedef struct _Dicts Dicts;
typedef struct _DictsClass DictsClass;

struct _Dicts {
    GObject	    parent_instance;
    GData	    *data;
    GtkTreeStore    *store;
    Builder	    *builder;
    gint	    active_group;
};

struct _DictsClass {
    GObjectClass    parent_class;
};

gint		    dicts_load(Dicts *self);
void		    dicts_save(Dicts *self);
gboolean	    dicts_get_nth(Dicts *self, gint n, GtkTreeIter *iter);

GType		    dicts_get_type (void);

G_END_DECLS

void		    dicts_select_all(gpointer data);
void		    dicts_unselect_all(gpointer data);
void		    dicts_next_group(gpointer data);
void		    dicts_prev_group(gpointer data);

#endif /* __DICTS_H__ */

