
#ifndef __DEFS_H__
#define __DEFS_H__

/* Disable old GTK+ functions */
#define GDK_DISABLE_DEPRECATED 1
#define GTK_DISABLE_DEPRECATED 1
#define GDK_DISABLE_SINGLE_INCLUDES 1
#define GTK_DISABLE_SINGLE_INCLUDES 1

#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <locale.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <intl.h>

/* Various includes */
#include <libxml/HTMLparser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <pango/pangox.h>
#include <langinfo.h>

/* Platform specific includes */
#include <X11/X.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

/* EB Library includes */
#include <eb/eb.h>
#include <eb/defs.h>
#include <eb/text.h>
#include <eb/font.h>
#include <eb/appendix.h>
#include <eb/error.h>
#include <eb/binary.h>

#ifdef ENABLE_GSTREAMER
#include <gst/gst.h>
#include <gst/base/gstbasesrc.h>
#include <gst/interfaces/xoverlay.h>
#include <gst/video/video.h>
#endif

#include "../config.h"

#define ENC_UTF8            "utf-8"
#define ENC_EUC_JP          "euc-jp"
#define ENC_SHIFT_JIS       "shift-jis"
#define ENC_ISO_2022_JP     "iso-2022-jp"
#define ENC_ASCII           "ascii"

#ifndef SZ
#define SZ(a) (sizeof(a)/sizeof(a[0]))
#endif

typedef struct
{
    gboolean active;
    gchar *title, *path, *appendix_path, *subbook_dir;
    EB_Book *book;
    EB_Appendix *appendix;
    EB_Subbook_Code subbook_no, appendix_subbook_no;
} BOOK_INFO;

typedef struct _result_eb
{
    gchar *book_title;
    gchar *heading;
    BOOK_INFO *binfo;
    EB_Position pos;
    gint size;
    gchar *filename;
} RESULT;

enum
{
    SEARCH_METHOD_FORWARD,
    SEARCH_METHOD_BACKWARD,
    SEARCH_METHOD_EXACTWORD,
    SEARCH_METHOD_KEYWORD,
    SEARCH_METHOD_MENU,
    SEARCH_METHOD_COPYRIGHT,
    SEARCH_METHOD_UNKNOWN
};

enum
{
    COLOR_LINK,
    COLOR_KEYWORD,
    COLOR_TITLE,
    COLOR_N
};

enum
{
    DICT_ALIAS,
    DICT_BINFO,
    DICT_EDITABLE,
    DICT_N
};

#include "log.h"

#define FILENAME_DICTS	    "dictionaries.xml"
#define FILENAME_PREFS	    "preferences.xml"
#define FILENAME_HOTKEYS    "hotkeys.xml"
#define FILENAME_HISTORY    "history.xml"

#endif /* __DEFS_H__ */

