
#ifndef __BUILDER_H__
#define __BUILDER_H__

G_BEGIN_DECLS

#define TYPE_BUILDER (builder_get_type ())
#define BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILDER, Builder))
#define BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILDER, BuilderClass))
#define IS_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILDER))
#define IS_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILDER))
#define BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILDER, BuilderClass))

typedef struct _Builder Builder;
typedef struct _BuilderClass BuilderClass;

struct _Builder {
    GtkBuilder	    parent_instance;
};

struct _BuilderClass {
    GtkBuilderClass parent_class;
};

void		    builder_load(Builder *self);

GtkTreeStore*	    builder_get_dicts(Builder *self);
gboolean	    builder_get_iter_n(GtkTreeModel *m, GtkTreeIter *iter, gint n);

void		    builder_grab_focus(Builder *self, gchar *name);
void		    builder_set_visible(Builder *self, gchar *name, gboolean visible);
void		    builder_install_text_cellrenderer(Builder *self, gchar *box);

gint		    builder_get_int(Builder *self, const gchar *name);
void		    builder_set_int(Builder *self, const gchar *name, gint value);

const gchar*	    builder_get_str(Builder *self, const gchar *name);
void		    builder_set_str(Builder *self, const gchar *name, const gchar *value);

GType		    builder_get_type (void);

G_END_DECLS

#endif /* __BUILDER_H__ */

