
#include "defs.h"

#include "builder.h"

G_DEFINE_TYPE(Builder, builder, GTK_TYPE_BUILDER);

Builder *_builder = NULL;

static void builder_class_init(BuilderClass *klass)
{
}

static void builder_init(Builder *self)
{
    builder_load(self);
    _builder = self;
}

static int builder_load_glade_xml(Builder *self, gchar *dir)
{
    gchar *fname = g_build_filename(dir, "eb123.glade", NULL);
    int res = gtk_builder_add_from_file(GTK_BUILDER(self), fname, NULL);
    g_free(fname);
    return res;
}

void builder_load(Builder *self)
{
    int res = builder_load_glade_xml(self, "");
    if(!res)
    {
#ifdef EB123_DATADIR
	res = builder_load_glade_xml(self, EB123_DATADIR);
#endif
    }
    if(!res)
    {
        LOG(LOG_ERROR, "failed to load glade ui\n");
	gtk_main_quit();
    }
}

void builder_grab_focus(Builder *self, gchar *name)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(w)
    {
	gtk_widget_grab_focus(w);
    }
}

void builder_set_visible(Builder *self, gchar *name, gboolean visible)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(w)
    {
	gtk_widget_set_visible(w, visible);
    }
}

gint builder_get_int(Builder *self, const gchar *name)
{
    gint ret = 0;
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(GTK_IS_SPIN_BUTTON(w))
    {
	ret = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w));
    }
    if(GTK_IS_COMBO_BOX(w) || GTK_IS_COMBO_BOX_TEXT(w))
    {
	ret = gtk_combo_box_get_active(GTK_COMBO_BOX(w));
    }
    if(GTK_IS_TOGGLE_BUTTON(w))
    {
        ret = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
    }
    return ret;
}

void builder_set_int(Builder *self, const gchar *name, gint value)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(GTK_IS_SPIN_BUTTON(w))
    {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(w), value);
    }
    if(GTK_IS_COMBO_BOX(w) || GTK_IS_COMBO_BOX_TEXT(w))
    {
	gtk_combo_box_set_active(GTK_COMBO_BOX(w), value);
    }
    if(GTK_IS_TOGGLE_BUTTON(w))
    {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), value);
    }
    if(GTK_IS_ENTRY(w))
    {
	gchar buf[16];
	sprintf(buf, "%d", value);
	return gtk_entry_set_text(GTK_ENTRY(w), (value >= 0) ? buf : "");
    }
}

const gchar* builder_get_str(Builder *self, const gchar *name)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(GTK_IS_ENTRY(w))
    {
	return gtk_entry_get_text(GTK_ENTRY(w));
    }
    if(GTK_IS_COMBO_BOX_TEXT(w))
    {
	return gtk_combo_box_text_get_active_text(GTK_COMBO_BOX_TEXT(w));
    }
    if(GTK_IS_COMBO_BOX(w))
    {
	GtkComboBox *combo = GTK_COMBO_BOX(w);
	if(gtk_combo_box_get_has_entry(combo))
	{
	    return gtk_entry_get_text(GTK_ENTRY(gtk_bin_get_child(GTK_BIN(combo))));
	}
	gint n = gtk_combo_box_get_active(GTK_COMBO_BOX(w));
	if(n >= 0)
	{
	    GtkTreeModel *m = gtk_combo_box_get_model(GTK_COMBO_BOX(w));
	    if(GTK_IS_LIST_STORE(m))
	    {
		GtkTreeIter iter;
		if(gtk_tree_model_iter_nth_child(m, &iter, NULL, n))
		{
		    gchar *str;
		    gtk_tree_model_get(m, &iter, 0, &str, -1);
		    return str;
		}
	    }
	}
    }
    if(GTK_IS_COLOR_BUTTON(w))
    {
	GdkColor color;
	gtk_color_button_get_color(GTK_COLOR_BUTTON(w), &color);
	return gtk_color_selection_palette_to_string(&color, 1);
    }
    if(GTK_IS_FONT_BUTTON(w))
    {
	return gtk_font_button_get_font_name(GTK_FONT_BUTTON(w));
    }
    if(GTK_IS_LABEL(w))
    {
	return gtk_label_get_text(GTK_LABEL(w));
    }
    return NULL;
}

void builder_set_str(Builder *self, const gchar *name, const gchar *value)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), name));
    if(GTK_IS_ENTRY(w))
    {
	gtk_entry_set_text(GTK_ENTRY(w), value);
    }
    if(GTK_IS_COLOR_BUTTON(w))
    {
	GdkColor color;
	gdk_color_parse(value, &color);
	gtk_color_button_set_color(GTK_COLOR_BUTTON(w), &color);
    }
    if(GTK_IS_LABEL(w))
    {
	gtk_label_set_text(GTK_LABEL(w), value);
    }
    if(GTK_IS_FONT_BUTTON(w))
    {
	gtk_font_button_set_font_name(GTK_FONT_BUTTON(w), value);
    }
    if(GTK_IS_COMBO_BOX(w))
    {
	if(gtk_combo_box_get_has_entry(GTK_COMBO_BOX(w)))
	{
	    GtkEntry *entry = GTK_ENTRY(gtk_bin_get_child(GTK_BIN(w)));
	    gtk_entry_set_text(entry, value);
	}
    }
}

void builder_install_text_cellrenderer(Builder *self, gchar *box)
{
    GtkWidget *w = GTK_WIDGET(gtk_builder_get_object(GTK_BUILDER(self), box));
    if((GTK_IS_COMBO_BOX(w) || GTK_IS_TREE_VIEW(w)) && !GTK_IS_COMBO_BOX_TEXT(w))
    {
	GtkCellRenderer *cell = gtk_cell_renderer_text_new();
	gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(w), cell, TRUE);
	gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(w), cell, "text", 0, NULL);
    }
}

