
#ifndef __AUDIO_H__
#define __AUDIO_H__

#include "render.h"

G_BEGIN_DECLS

#define TYPE_AUDIO (audio_get_type ())
#define AUDIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDIO, Audio))
#define AUDIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDIO, AudioClass))
#define IS_AUDIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDIO))
#define IS_AUDIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDIO))
#define AUDIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDIO, AudioClass))

typedef struct _Audio Audio;
typedef struct _AudioClass AudioClass;

struct _Audio {
    GtkFrame	    parent_instance;
    GtkWidget	    *save_btn;
    GtkWidget	    *play_btn;
};

struct _AudioClass {
    GtkFrameClass   parent_class;
};

void		audio_output_finalize(Audio *self);
void		audio_render(Audio *self, RenderTextCtx *ctx);

GType		audio_get_type (void);

G_END_DECLS

#endif /* __AUDIO_H__ */
