package jp.ac.osaka_u.sparql;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.hp.hpl.jena.rdf.model.RDFNode;

import jp.ac.osaka_u.sanken.sparql.EndpointSettings;

public abstract class SparqlServletBase extends ServletBase {

	protected static final String DATA_TYPE = "species";

	protected 	History history;


	
	protected String getString(RDFNode node){
		if (node == null){
			return null;
		}
		if (node.isLiteral()){
			return (node.asLiteral()).getString();
		} else {
			return (node.toString());
		}
	}

	
	EndpointSettings getEndpointSettings(HttpServletRequest request){
		HttpSession session = request.getSession(true);
		return (EndpointSettings)session.getAttribute("session");

	}

}
