/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import jp.ac.osaka_u.sanken.sparql.CustomSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;

public class WikipediaontologyAccessor
extends CustomSparqlAccessor {
    public WikipediaontologyAccessor(EndpointSettings endpoint) {
        super(endpoint);
    }

    public WikipediaontologyAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        super(endpoint, queryListener);
    }

    @Override
    protected ResultSet customQuery(String query) throws Exception {
        URL url = new URL(this.setting.getEndpoint());
        String param = "q=" + URLEncoder.encode(query, this.setting.getEncoding()) + "&type=xml&LIMIT=100";
        System.out.println("param:" + param);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        conn.setDoOutput(true);
        DataOutputStream os = new DataOutputStream(conn.getOutputStream());
        os.writeBytes(param);
        os.flush();
        os.close();
        ResultSet ret = null;
        String contents = this.getStreamContents(conn.getInputStream());
        ret = ResultSetFactory.fromXML((String)contents);
        return ret;
    }

    @Override
    protected String getQueryLimit(int limit) {
        return "";
    }

    @Override
    protected String getQueryOffset(int offset) {
        return "";
    }

    @Override
    protected String getParamLimit(int limit) {
        return "&LIMIT=" + (limit + 1);
    }
}

