/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.rdf.model.RDFNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.SeparatedValuesExporter;

public class SparqlUtil {
    public static final int OUTPUT_TYPE_TSV = 0;
    public static final int OUTPUT_TYPE_CSV = 1;
    public static final int OUTPUT_TYPE_XLS = 2;
    private static HashMap<Integer, String> separatorMap = new HashMap();

    static {
        separatorMap.put(0, "\t");
        separatorMap.put(1, ",");
    }

    public static boolean saveResult(List<Map<String, RDFNode>> results, int type, OutputStream stream) {
        if (type == 0 || type == 1) {
            String separator = separatorMap.get(type);
            if (separator == null) {
                return false;
            }
            SeparatedValuesExporter expo = new SeparatedValuesExporter(separator, results);
            try {
                expo.export(stream);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public static boolean saveResult(List<Map<String, RDFNode>> results, int type, File file) throws FileNotFoundException {
        return SparqlUtil.saveResult(results, type, new FileOutputStream(file));
    }
}

