/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlWebAccessorBase;

public class CustomSparqlAccessor
extends SparqlWebAccessorBase {
    public CustomSparqlAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        super(endpoint, queryListener);
    }

    public CustomSparqlAccessor(EndpointSettings endpoint) {
        super(endpoint);
    }

    @Override
    protected ResultSet customQuery(String query) throws Exception {
        URL url = new URL(String.valueOf(this.setting.getEndpoint()) + "?" + this.setting.getQueryKey() + "=" + URLEncoder.encode(query, this.setting.getEncoding()) + "&" + this.setting.getOption());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        int resultType = this.setting.getResultType();
        ResultSet ret = null;
        if (resultType == 1) {
            int bf;
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("c:\\temp\\out.out")));
            while ((bf = br.read()) != -1) {
                bw.write(bf);
            }
            bw.close();
            br.close();
            ret = ResultSetFactory.fromJSON((InputStream)conn.getInputStream());
        } else if (resultType == 0) {
            ret = ResultSetFactory.fromXML((InputStream)conn.getInputStream());
        } else if (resultType == 2) {
            ret = ResultSetFactory.fromSSE((InputStream)conn.getInputStream());
        } else if (resultType == 3) {
            ret = ResultSetFactory.fromTSV((InputStream)conn.getInputStream());
        }
        conn.disconnect();
        return ret;
    }

    @Override
    protected String getQueryLimit(int limit) {
        return "LIMIT " + limit;
    }

    @Override
    protected String getQueryOffset(int offset) {
        return "OFFSET " + offset;
    }

    @Override
    protected String getParamLimit(int limit) {
        return "";
    }
}

