/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.arnx.jsonic.io.InputSource;

public class ReaderInputSource
implements InputSource {
    long lines = 1L;
    long columns = 1L;
    long offset = 0L;
    final Reader reader;
    final char[] buf = new char[256];
    int start = 0;
    int end = 0;

    public ReaderInputSource(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        this.reader = new InputStreamReader(in, this.determineEncoding(in));
    }

    public ReaderInputSource(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public int next() throws IOException {
        char c;
        if (this.start == this.end) {
            int size = this.reader.read(this.buf, this.start, Math.min(this.buf.length - this.start, this.buf.length / 2));
            if (size != -1) {
                this.end = (this.end + size) % this.buf.length;
            } else {
                return -1;
            }
        }
        if ((c = this.buf[this.start]) == '\r' || c == '\n' && this.buf[(this.start + this.buf.length - 1) % this.buf.length] != '\r') {
            ++this.lines;
            this.columns = 0L;
        } else {
            ++this.columns;
        }
        ++this.offset;
        this.start = (this.start + 1) % this.buf.length;
        return c;
    }

    public void back() {
        --this.offset;
        --this.columns;
        this.start = (this.start + this.buf.length - 1) % this.buf.length;
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    String determineEncoding(InputStream in) throws IOException {
        String encoding = "UTF-8";
        in.mark(4);
        byte[] check = new byte[4];
        int size = in.read(check);
        if (size == 2) {
            if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) != 0 || (check[0] & 0xFF) == 254 && (check[1] & 0xFF) == 255) {
                encoding = "UTF-16BE";
            } else if ((check[0] & 0xFF) != 0 && (check[1] & 0xFF) == 0 || (check[0] & 0xFF) == 255 && (check[1] & 0xFF) == 254) {
                encoding = "UTF-16LE";
            }
        } else if (size == 4) {
            if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) == 0) {
                encoding = "UTF-32BE";
            } else if ((check[2] & 0xFF) == 0 && (check[3] & 0xFF) == 0) {
                encoding = "UTF-32LE";
            } else if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) != 0 || (check[0] & 0xFF) == 254 && (check[1] & 0xFF) == 255) {
                encoding = "UTF-16BE";
            } else if ((check[0] & 0xFF) != 0 && (check[1] & 0xFF) == 0 || (check[0] & 0xFF) == 255 && (check[1] & 0xFF) == 254) {
                encoding = "UTF-16LE";
            }
        }
        in.reset();
        return encoding;
    }

    public String toString() {
        int maxlength;
        StringBuffer sb = new StringBuffer();
        for (int i = maxlength = this.columns - 1L < (long)this.buf.length ? (int)this.columns - 1 : this.buf.length - 1; i >= 0; --i) {
            sb.append(this.buf[(this.start - 2 + this.buf.length - i) % (this.buf.length - 1)]);
        }
        return sb.toString();
    }
}

