/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql.edit;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import java.util.ArrayList;
import java.util.List;
import jp.ac.osaka_u.sanken.sparql.AllegroAccessor;
import org.openrdf.repository.RepositoryConnection;

public class AllegroEditor {
    private AllegroAccessor accessor;
    private String user;
    private String pass;
    private String url;
    private String repository;
    private static List<RepositoryConnection> toClose = new ArrayList<RepositoryConnection>();
    private static List<AGRepository> toCloseRep = new ArrayList<AGRepository>();
    private static List<AGModel> toCloseModel = new ArrayList<AGModel>();

    public AllegroEditor(AllegroAccessor sa, String user, String pass) throws Exception {
        this.accessor = sa;
        this.user = user;
        this.pass = pass;
        this.init();
    }

    public AllegroEditor(AllegroAccessor sa, String url, String repo, String user, String pass) throws Exception {
        this.accessor = sa;
        this.url = url;
        this.repository = repo;
        this.user = user;
        this.pass = pass;
        try {
            this.getModel();
        }
        catch (Exception e) {
            throw new Exception("AllegroGraph\u306erepository\u8a2d\u5b9a\u304c\u4e0d\u6b63\u3067\u3059", e);
        }
    }

    private void init() throws Exception {
        String endpoint = this.accessor.getSetting().getEndpoint();
        int index = endpoint.indexOf("/endpoint/");
        if (index < 0) {
            throw new Exception("AllegroGraph\u30b5\u30fc\u30d0\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        this.url = endpoint.substring(0, index);
        this.repository = endpoint.substring(index + "/endpoint/".length());
        System.out.println("url:" + this.url);
        System.out.println("repo:" + this.repository);
    }

    public AllegroAccessor getAccessor() {
        return this.accessor;
    }

    public void close() {
        this.closeAll();
    }

    public boolean contains(RDFNode s, RDFNode p, RDFNode o) throws Exception {
        Model model = this.getModel();
        return this.contains(s, p, o, model);
    }

    private boolean isTriple(RDFNode s, RDFNode p, RDFNode o) {
        if (!s.isResource()) {
            return false;
        }
        return p.isResource();
    }

    private boolean contains(RDFNode s, RDFNode p, RDFNode o, Model model) {
        if (!this.isTriple(s, p, o)) {
            return false;
        }
        Resource ss = s.asResource();
        PropertyImpl pp = new PropertyImpl(p.asResource().getURI());
        return model.contains(ss, (Property)pp, o);
    }

    public boolean add(RDFNode s, RDFNode p, String o) throws Exception {
        Model model = this.getModel();
        Literal oo = model.createLiteral(o);
        return this.add(s, p, (RDFNode)oo, model);
    }

    public boolean add(RDFNode s, RDFNode p, RDFNode o) throws Exception {
        Model model = this.getModel();
        return this.add(s, p, o, model);
    }

    private boolean add(RDFNode s, RDFNode p, RDFNode o, Model model) {
        PropertyImpl pp;
        if (!this.isTriple(s, p, o)) {
            return false;
        }
        Resource ss = s.asResource();
        if (!model.contains(ss, (Property)(pp = new PropertyImpl(p.asResource().getURI())), o)) {
            model.add(ss, (Property)pp, o);
            return true;
        }
        return false;
    }

    public boolean delete(RDFNode s, RDFNode p, RDFNode o) throws Exception {
        Model model = this.getModel();
        return this.delete(s, p, o, model);
    }

    private boolean delete(RDFNode s, RDFNode p, RDFNode o, Model model) {
        PropertyImpl pp;
        if (!this.isTriple(s, p, o)) {
            return false;
        }
        Resource ss = s.asResource();
        if (model.contains(ss, (Property)(pp = new PropertyImpl(p.asResource().getURI())), o)) {
            model.remove(ss, (Property)pp, o);
            return true;
        }
        return false;
    }

    public boolean edit(RDFNode s, RDFNode p, RDFNode o, RDFNode s2, RDFNode p2, RDFNode o2) throws Exception {
        Model model = this.getModel();
        return this.edit(s, p, o, s2, p2, o2, model);
    }

    private boolean edit(RDFNode s, RDFNode p, RDFNode o, RDFNode s2, RDFNode p2, RDFNode o2, Model model) {
        if (!this.isTriple(s, p, o) || !this.isTriple(s2, p2, o2)) {
            return false;
        }
        Resource ss = s.asResource();
        PropertyImpl pp = new PropertyImpl(p.asResource().getURI());
        Resource ss2 = s2.asResource();
        PropertyImpl pp2 = new PropertyImpl(p2.asResource().getURI());
        if (model.contains(ss, (Property)pp, o)) {
            model.remove(ss, (Property)pp, o);
            model.add(ss2, (Property)pp2, o2);
            return true;
        }
        return false;
    }

    public Model getModel() throws Exception {
        AGServer server = new AGServer(this.url, this.user, this.pass);
        AGCatalog catalog = server.getCatalog("/");
        AGRepository myRepository = catalog.openRepository(this.repository);
        AGRepositoryConnection conn = myRepository.getConnection();
        AllegroEditor.closeBeforeExit((RepositoryConnection)conn);
        AGGraphMaker maker = new AGGraphMaker(conn);
        AGGraph graph = maker.getGraph();
        AGModel model = new AGModel(graph);
        this.closeBeforeExit(myRepository, model);
        return model;
    }

    private void closeBeforeExit(AGRepository rep, AGModel model) {
        toCloseRep.add(rep);
        toCloseModel.add(model);
    }

    protected void closeAll() {
        AGRepository conn;
        while (!toCloseRep.isEmpty()) {
            conn = toCloseRep.get(0);
            this.close(conn);
            while (toCloseRep.remove(conn)) {
            }
        }
        while (!toCloseModel.isEmpty()) {
            conn = toCloseModel.get(0);
            this.close((AGModel)conn);
            while (toCloseModel.remove(conn)) {
            }
        }
        while (!toClose.isEmpty()) {
            conn = toClose.get(0);
            AllegroEditor.close((RepositoryConnection)conn);
            while (toClose.remove(conn)) {
            }
        }
    }

    static void close(RepositoryConnection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            System.err.println("Error closing repository connection: " + e);
            e.printStackTrace();
        }
    }

    void close(AGRepository conn) {
        try {
            conn.shutDown();
        }
        catch (Exception e) {
            System.err.println("Error closing repository repository: " + e);
            e.printStackTrace();
        }
    }

    void close(AGModel conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            System.err.println("Error closing repository model: " + e);
            e.printStackTrace();
        }
    }

    private static void closeBeforeExit(RepositoryConnection conn) {
        toClose.add(conn);
    }
}

