/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import jp.ac.osaka_u.sanken.sparql.CustomSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;

public class VirtuosoAccessor
extends CustomSparqlAccessor {
    public VirtuosoAccessor(EndpointSettings endpoint) {
        super(endpoint);
    }

    public VirtuosoAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        super(endpoint, queryListener);
    }

    @Override
    protected ResultSet customQuery(String query) throws Exception {
        URL url = new URL(String.valueOf(this.setting.getEndpoint()) + "?query=" + URLEncoder.encode(query, this.setting.getEncoding()) + "&format=application%2fsparql%2dresults%2bjson&output=json");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded'");
        conn.setRequestProperty("Accept", "application/sparql-results+json");
        conn.setDoOutput(true);
        ResultSet ret = null;
        InputStream is = this.getStream(conn.getInputStream());
        ret = ResultSetFactory.fromJSON((InputStream)is);
        is.close();
        conn.disconnect();
        return ret;
    }

    private InputStream getStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = br.readLine();
        while (line != null) {
            line = this.escape(line);
            bw.write(String.valueOf(line) + "\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    private String escape(String line) {
        line = line.replaceAll("\"literal-typed\"", "\"literal\"");
        return line;
    }
}

