/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import java.util.List;
import jp.ac.osaka_u.sanken.sparql.CrossSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.CustomSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.EpcuAccessor;
import jp.ac.osaka_u.sanken.sparql.FukushimaAccessor;
import jp.ac.osaka_u.sanken.sparql.SociaAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.VirtuosoAccessor;
import jp.ac.osaka_u.sanken.sparql.WikipediaontologyAccessor;
import jp.ac.osaka_u.sanken.sparql.WordnetAccessor;

public class SparqlAccessorFactory {
    public static SparqlAccessor createSparqlAccessor(EndpointSettings setting) {
        if (setting.isEditable()) {
            return new VirtuosoAccessor(setting);
        }
        if (setting.isUseCustomParam()) {
            return new CustomSparqlAccessor(setting);
        }
        if (setting.getEndpoint().contains("SparqlEPCU")) {
            return new EpcuAccessor(setting);
        }
        if (setting.getEndpoint().contains("wikipediaontology")) {
            return new WikipediaontologyAccessor(setting);
        }
        if (setting.getEndpoint().contains("fukushima.archive-disasters.jp")) {
            return new FukushimaAccessor(setting);
        }
        if (setting.getEndpoint().contains("wordnet")) {
            return new WordnetAccessor(setting);
        }
        if (setting.getEndpoint().contains("socia")) {
            return new SociaAccessor(setting);
        }
        return new VirtuosoAccessor(setting);
    }

    public static SparqlAccessor createSparqlAccessor(List<EndpointSettings> settings) {
        return new CrossSparqlAccessor(settings);
    }

    public static ThreadedSparqlAccessor createSparqlAccessor(EndpointSettings setting, SparqlQueryListener listener) {
        if (setting.isEditable()) {
            return new VirtuosoAccessor(setting, listener);
        }
        if (setting.isUseCustomParam()) {
            return new CustomSparqlAccessor(setting, listener);
        }
        if (setting.getEndpoint().contains("SparqlEPCU")) {
            return new EpcuAccessor(setting, listener);
        }
        if (setting.getEndpoint().contains("wikipediaontology")) {
            return new WikipediaontologyAccessor(setting, listener);
        }
        if (setting.getEndpoint().contains("fukushima.archive-disasters.jp")) {
            return new FukushimaAccessor(setting, listener);
        }
        if (setting.getEndpoint().contains("wordnet")) {
            return new WordnetAccessor(setting, listener);
        }
        if (setting.getEndpoint().contains("socia")) {
            return new SociaAccessor(setting, listener);
        }
        return new VirtuosoAccessor(setting, listener);
    }

    public static ThreadedSparqlAccessor createSparqlAccessor(List<EndpointSettings> settings, SparqlQueryListener listener) {
        return new CrossSparqlAccessor(settings, listener);
    }
}

