package jp.ac.osaka_u.sanken.sparql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.hp.hpl.jena.rdf.model.RDFNode;

public class SparqlResultSet {

	private final String DEFAULT_KEY = "_"; 
	
	private Map<String, List<Map<String, RDFNode>>> result;
	private boolean hasNext;

	public SparqlResultSet(List<Map<String, RDFNode>> result){
		this(result, false);
	}

	public SparqlResultSet(List<Map<String, RDFNode>> result, boolean hasNext){
		this.result = new LinkedHashMap<String, List<Map<String, RDFNode>>>();
		this.result.put(DEFAULT_KEY, result);
		this.hasNext = hasNext;
	}

	/**
	 * @return result
	 */
	public List<Map<String, RDFNode>> getDefaultResult() {
		return getResult(DEFAULT_KEY);
	}

	public List<Map<String, RDFNode>> getResult(String endpoint) {
		return result.get(endpoint);
	}
	
	public Map<String, List<Map<String, RDFNode>>> getResult(){
		return result;
	}

	
	/**
	 * @param result セットする result
	 */
	public void setDefaultResult(List<Map<String, RDFNode>> result) {
		this.addResult(DEFAULT_KEY, result);
	}

	public void addResult(String endpoint, List<Map<String, RDFNode>> result) {
		this.result.put(endpoint, result);
	}

	
	/**
	 * @return hasNext
	 */
	public boolean isHasNext() {
		return hasNext;
	}

	/**
	 * @param hasNext セットする hasNext
	 */
	public void setHasNext(boolean hasNext) {
		this.hasNext = hasNext;
	}


}
