/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.impl;

import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;
import org.apache.xerces.util.XMLChar;

public class PrefixMappingImpl
implements PrefixMapping {
    protected Map<String, String> prefixToURI = CollectionFactory.createHashedMap();
    protected Map<String, String> URItoPrefix = CollectionFactory.createHashedMap();
    protected boolean locked;

    protected void set(String prefix, String uri) {
        this.prefixToURI.put(prefix, uri);
        this.URItoPrefix.put(uri, prefix);
    }

    protected String get(String prefix) {
        return this.prefixToURI.get(prefix);
    }

    @Override
    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.checkLegal(prefix);
        if (!prefix.equals("")) {
            this.checkProper(uri);
        }
        if (uri == null) {
            throw new NullPointerException("null URIs are prohibited as arguments to setNsPrefix");
        }
        this.set(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        String uri = this.prefixToURI.remove(prefix);
        this.regenerateReverseMapping();
        return this;
    }

    protected void regenerateReverseMapping() {
        this.URItoPrefix.clear();
        for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
            this.URItoPrefix.put(e.getValue(), e.getKey());
        }
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    private void checkProper(String uri) {
    }

    public static boolean isNiceURI(String uri) {
        if (uri.equals("")) {
            return false;
        }
        char last = uri.charAt(uri.length() - 1);
        return Util.notNameChar(last);
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.checkUnlocked();
        for (Map.Entry<String, String> e : other.getNsPrefixMap().entrySet()) {
            String prefix = e.getKey();
            String uri = e.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> other) {
        this.checkUnlocked();
        for (Map.Entry<String, String> e : other.entrySet()) {
            this.setNsPrefix(e.getKey(), e.getValue());
        }
        return this;
    }

    private void checkLegal(String prefix) {
        if (prefix.length() > 0 && !XMLChar.isValidNCName((String)prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.get(prefix);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return CollectionFactory.createHashedMap(this.prefixToURI);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.URItoPrefix.get(uri);
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String uri = this.get(prefixed.substring(0, colon));
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public String toString() {
        return "pm:" + this.prefixToURI;
    }

    @Override
    public String qnameFor(String uri) {
        int split = Util.splitNamespace(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.URItoPrefix.get(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    @Override
    public String shortForm(String uri) {
        Map.Entry<String, String> e = this.findMapping(uri, true);
        return e == null ? uri : e.getKey() + ":" + uri.substring(e.getValue().length());
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return other instanceof PrefixMappingImpl ? this.equals((PrefixMappingImpl)other) : this.equalsByMap(other);
    }

    protected boolean equals(PrefixMappingImpl other) {
        return other.sameAs(this);
    }

    protected boolean sameAs(PrefixMappingImpl other) {
        return ((Object)this.prefixToURI).equals(other.prefixToURI);
    }

    protected final boolean equalsByMap(PrefixMapping other) {
        return ((Object)this.getNsPrefixMap()).equals(other.getNsPrefixMap());
    }

    private Map.Entry<String, String> findMapping(String uri, boolean partial) {
        for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
            String ss = e.getValue();
            if (!uri.startsWith(ss) || !partial && ss.length() != uri.length()) continue;
            return e;
        }
        return null;
    }
}

