/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import java.util.Map;

public class MapWithScope<A, B, S> {
    private final ScopePolicy<A, B, S> scopePolicy;
    private final Allocator<A, B> allocator;

    protected MapWithScope(ScopePolicy<A, B, S> scopePolicy, Allocator<A, B> allocator) {
        this.scopePolicy = scopePolicy;
        this.allocator = allocator;
    }

    public B get(S scope, A item) {
        Map<A, B> map = this.scopePolicy.getScope(scope);
        B mappedItem = map.get(item);
        if (mappedItem == null) {
            mappedItem = this.allocator.create(item);
            map.put(item, mappedItem);
        }
        return mappedItem;
    }

    public B create() {
        return this.allocator.create(null);
    }

    public void clear() {
        this.scopePolicy.clear();
        this.allocator.reset();
    }

    protected static interface Allocator<A, B> {
        public B create(A var1);

        public void reset();
    }

    protected static interface ScopePolicy<A, B, S> {
        public Map<A, B> getScope(S var1);

        public void clear();
    }
}

