/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.logging.Log;

public class Lib {
    private static Checksum crc32 = new CRC32();
    private static Checksum adler32 = new Adler32();

    private Lib() {
    }

    public static final void sync(Object object) {
        if (object instanceof Sync) {
            ((Sync)object).sync();
        }
    }

    public static final <T> boolean equal(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static final <T> boolean notEqual(T obj1, T obj2) {
        return !Lib.equal(obj1, obj2);
    }

    public static final String className(Object obj) {
        return Lib.classShortName(obj.getClass());
    }

    public static final String classShortName(Class<?> cls) {
        return cls.getSimpleName();
    }

    public static <T> boolean equalsListAsSet(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null) {
            return false;
        }
        if (list2 == null) {
            return false;
        }
        return list1.containsAll(list2) && list2.containsAll(list1);
    }

    public static final int hashCodeObject(Object obj) {
        return Lib.hashCodeObject(obj, -4);
    }

    public static final int hashCodeObject(Object obj, int nullHashCode) {
        if (obj == null) {
            return nullHashCode;
        }
        return obj.hashCode();
    }

    public static final void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException ex) {
            Log.warn(Lib.class, "interrupted", (Throwable)ex);
        }
    }

    public static long crc32(byte[] bytes) {
        return Lib.crc(crc32, bytes);
    }

    public static long adler32(byte[] bytes) {
        return Lib.crc(adler32, bytes);
    }

    private static long crc(Checksum alg, byte[] bytes) {
        alg.reset();
        alg.update(bytes, 0, bytes.length);
        return alg.getValue();
    }
}

