/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;

public abstract class FunctionBase4
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 4) {
            throw new QueryBuildException("Function '" + Utils.className(this) + "' takes four arguments");
        }
    }

    @Override
    public final NodeValue exec(List<NodeValue> args) {
        if (args == null) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Null args list");
        }
        if (args.size() != 4) {
            throw new ExprEvalException(Utils.className(this) + ": Wrong number of arguments: Wanted 4, got " + args.size());
        }
        NodeValue v1 = args.get(0);
        NodeValue v2 = args.get(1);
        NodeValue v3 = args.get(2);
        NodeValue v4 = args.get(3);
        return this.exec(v1, v2, v3, v4);
    }

    public abstract NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3, NodeValue var4);
}

