/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.Collection;
import java.util.Stack;

public class AlgebraQuad
extends TransformCopy {
    private AlgebraQuad() {
    }

    public static Op quadize(Op op) {
        Stack<QuadSlot> stack = new Stack<QuadSlot>();
        QuadSlot qSlot = new QuadSlot(Quad.defaultGraphNodeGenerated, Quad.defaultGraphNodeGenerated);
        stack.push(qSlot);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadGraph qg = new TransformQuadGraph(stack);
        return Transformer.transformSkipService(qg, op, before, after);
    }

    private static class TransformQuadGraph
    extends TransformCopy {
        private Stack<QuadSlot> tracker;

        public TransformQuadGraph(Stack<QuadSlot> tracker) {
            this.tracker = tracker;
        }

        private Node getNode() {
            return this.tracker.peek().rewriteGraphName;
        }

        @Override
        public Op transform(OpGraph opGraph, Op op) {
            boolean noPattern = false;
            QuadSlot qSlot = this.tracker.peek();
            Node actualName = qSlot.actualGraphName;
            Node rewriteName = qSlot.rewriteGraphName;
            if (OpBGP.isBGP(op)) {
                if (((OpBGP)op).getPattern().isEmpty()) {
                    noPattern = true;
                }
            } else if (op instanceof OpTable && ((OpTable)op).isJoinIdentity()) {
                noPattern = true;
            }
            if (noPattern) {
                return new OpDatasetNames(opGraph.getNode());
            }
            if (actualName != rewriteName) {
                op = OpAssign.assign(op, Var.alloc(actualName), new ExprVar(rewriteName));
            }
            return op;
        }

        @Override
        public Op transform(OpPropFunc opPropFunc, Op subOp) {
            if (opPropFunc.getSubOp() != subOp) {
                opPropFunc = new OpPropFunc(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), subOp);
            }
            return new OpGraph(this.getNode(), opPropFunc);
        }

        @Override
        public Op transform(OpPath opPath) {
            return new OpGraph(this.getNode(), opPath);
        }

        @Override
        public Op transform(OpBGP opBGP) {
            return new OpQuadPattern(this.getNode(), opBGP.getPattern());
        }
    }

    private static class Popper
    extends OpVisitorBase {
        Stack<QuadSlot> stack;

        Popper(Stack<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.stack.pop();
        }
    }

    private static class Pusher
    extends OpVisitorBase {
        Stack<QuadSlot> stack;
        VarAlloc varAlloc = new VarAlloc("*g");

        Pusher(Stack<QuadSlot> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Collection<Var> vars;
            Node gn;
            Object gnQuad = gn = opGraph.getNode();
            if (Var.isVar(gn) && (vars = OpVars.allVars(opGraph.getSubOp())).contains(gn)) {
                gnQuad = this.varAlloc.allocVar();
            }
            this.stack.push(new QuadSlot(gn, (Node)gnQuad));
        }
    }

    private static class QuadSlot {
        final Node actualGraphName;
        final Node rewriteGraphName;

        QuadSlot(Node actualGraphName, Node rewriteGraphName) {
            this.actualGraphName = actualGraphName;
            this.rewriteGraphName = rewriteGraphName;
        }
    }
}

