/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.exception.AGMalformedDataException;
import com.franz.agraph.http.exception.AGMalformedQueryException;
import com.franz.agraph.http.exception.AGPreconditionFailedException;
import com.franz.agraph.http.exception.AGUnsupportedFileFormatException;
import com.franz.agraph.http.exception.AGUnsupportedQueryLanguageException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public class AGErrorHandler
extends AGResponseHandler {
    public static final String MALFORMED_QUERY = "MALFORMED QUERY";
    public static final String MALFORMED_DATA = "MALFORMED DATA";
    public static final String UNSUPPORTED_QUERY_LANGUAGE = "UNSUPPORTED QUERY LANGUAGE";
    public static final String UNSUPPORTED_FILE_FORMAT = "UNSUPPORTED FILE FORMAT";
    public static final String PRECONDITION_FAILED = "PRECONDITION FAILED";
    public static final String IO_EXCEPTION = "IO EXCEPTION";
    private AGHttpException result = null;

    public AGErrorHandler() {
        super("text/plain");
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        InputStream response = AGErrorHandler.getInputStream(method);
        String errorString = AGErrorHandler.streamToString(response);
        this.result = AGErrorHandler.newException(errorString);
    }

    protected static AGHttpException newException(String errorString) {
        int colonIdx = errorString.indexOf(58);
        if (colonIdx >= 0) {
            String type = errorString.substring(0, colonIdx).trim();
            String message = errorString.substring(colonIdx + 1);
            if (MALFORMED_DATA.equals(type)) {
                return new AGMalformedDataException(message);
            }
            if (MALFORMED_QUERY.equals(type)) {
                return new AGMalformedQueryException(message);
            }
            if (PRECONDITION_FAILED.equals(type)) {
                return new AGPreconditionFailedException(message);
            }
            if (UNSUPPORTED_FILE_FORMAT.equals(type)) {
                return new AGUnsupportedFileFormatException(message);
            }
            if (UNSUPPORTED_QUERY_LANGUAGE.equals(type)) {
                return new AGUnsupportedQueryLanguageException(message);
            }
        }
        return new AGHttpException(errorString);
    }

    public AGHttpException getResult() {
        return this.result;
    }
}

