/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.Parser;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import java.io.IOException;

abstract class AbsLexer
implements ViolationCodes {
    protected Parser parser;
    protected int range;

    AbsLexer() {
    }

    public synchronized void analyse(Parser p, int r) {
        this.parser = p;
        this.range = r;
        if (!this.parser.has(this.range)) {
            return;
        }
        this.parser.uri.getChars(this.parser.start(this.range), this.parser.end(this.range), this.zzBuffer(), 0);
        try {
            this.yylex();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void analyse(Parser p, int r, String str, int strt, int finish) {
        this.parser = p;
        this.range = r;
        str.getChars(strt, finish, this.zzBuffer(), 0);
        try {
            this.yylex();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    abstract int yylex() throws IOException;

    abstract char[] zzBuffer();

    protected void error(int e) {
        this.parser.recordError(this.range, e);
    }

    protected final void rule(int rule) {
        this.parser.matchedRule(this.range, rule, this.yytext());
    }

    abstract String yytext();

    protected void surrogatePair() {
        try {
            String txt = this.yytext();
            this.difficultCodePoint(UCharacter.getCodePoint((char)txt.charAt(0), (char)txt.charAt(1)), txt);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void difficultCodePoint(int codePoint, String txt) {
        int lowBits;
        this.error(22);
        if (codePoint > 55295 && codePoint < 57344) {
            this.error(6);
        }
        if (codePoint > 65533 && codePoint < 65536) {
            this.error(6);
        }
        if (codePoint >= 64976 && codePoint <= 64991) {
            this.error(7);
        }
        if (codePoint > 65536 && ((lowBits = codePoint & 0xFFFF) == 65534 || lowBits == 65535)) {
            this.error(7);
        }
        if (UCharacter.hasBinaryProperty((int)codePoint, (int)6)) {
            this.error(48);
        }
        if (!UCharacter.isDefined((int)codePoint)) {
            this.error(49);
        }
        switch (UCharacter.getType((int)codePoint)) {
            case 17: {
                this.error(50);
                break;
            }
            case 15: {
                this.error(51);
                break;
            }
            case 0: {
                this.error(52);
            }
        }
        Normalizer.QuickCheckResult qcr = Normalizer.quickCheck((String)txt, (Normalizer.Mode)Normalizer.NFC);
        if (qcr.equals(Normalizer.NO)) {
            this.error(46);
        } else if (qcr.equals(Normalizer.MAYBE)) {
            this.error(53);
        }
        qcr = Normalizer.quickCheck((String)txt, (Normalizer.Mode)Normalizer.NFKC);
        if (qcr.equals(Normalizer.NO)) {
            this.error(47);
        } else if (qcr.equals(Normalizer.MAYBE)) {
            this.error(54);
        }
        if (UCharacter.isWhitespace((int)codePoint) || UCharacter.isUWhiteSpace((int)codePoint)) {
            this.error(55);
        }
        if (this.isCompatibilityChar(codePoint)) {
            this.error(56);
        }
    }

    private boolean isCompatibilityChar(int codePoint) {
        switch (UCharacter.getIntPropertyValue((int)codePoint, (int)4099)) {
            case 0: 
            case 1: {
                switch (UCharacter.UnicodeBlock.of((int)codePoint).getID()) {
                    case 69: {
                        switch (codePoint) {
                            case 64014: 
                            case 64015: 
                            case 64017: 
                            case 64019: 
                            case 64020: 
                            case 64031: 
                            case 64033: 
                            case 64035: 
                            case 64036: 
                            case 64039: 
                            case 64040: 
                            case 64041: {
                                return false;
                            }
                        }
                        return true;
                    }
                    case 58: 
                    case 59: 
                    case 65: 
                    case 83: 
                    case 95: {
                        return true;
                    }
                }
                break;
            }
            default: {
                return true;
            }
        }
        return !Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFD).equals(Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKD));
    }

    protected void difficultChar() {
        this.difficultCodePoint(this.yytext().charAt(0), this.yytext());
    }
}

