/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.arnx.jsonic.util.BeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInfo
implements Comparable<ConstructorInfo> {
    private Class<?> beanClass;
    List<Constructor<?>> constructors = new ArrayList();

    public ConstructorInfo(Class<?> beanClass, Collection<Constructor<?>> constructors) {
        this.beanClass = beanClass;
        if (constructors != null) {
            this.constructors.addAll(constructors);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Object newInstance(Object ... args) {
        Constructor<?> constructor = this.findConstructor(args);
        try {
            return constructor.newInstance(args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(ConstructorInfo constructor) {
        if (!this.beanClass.equals(constructor.beanClass)) {
            return this.beanClass.getName().compareTo(constructor.beanClass.getName());
        }
        return 0;
    }

    public Constructor<?> findConstructor(Object ... args) {
        Constructor<?> constructor = null;
        Class<?>[] types = null;
        Constructor<?> vconstructor = null;
        Class<?>[] vtypes = null;
        for (Constructor<?> cconstructor : this.constructors) {
            Class<?>[] cparams = cconstructor.getParameterTypes();
            if (cconstructor.isVarArgs()) {
                if (args.length < cparams.length - 1) continue;
                if (vconstructor == null) {
                    Class<?> vtype = cparams[cparams.length - 1].getComponentType();
                    Class[] tmp = new Class[args.length];
                    System.arraycopy(cparams, 0, tmp, 0, cparams.length - 1);
                    for (int i = cparams.length - 1; i < tmp.length; ++i) {
                        tmp[i] = vtype;
                    }
                    vconstructor = cconstructor;
                    vtypes = tmp;
                    continue;
                }
                int vpoint = BeanInfo.calcurateDistance(vtypes, args);
                int cpoint = BeanInfo.calcurateDistance(cparams, args);
                if (cpoint > vpoint) {
                    vconstructor = cconstructor;
                    vtypes = cparams;
                    continue;
                }
                if (cpoint != vpoint) continue;
                cconstructor = null;
                cparams = null;
                continue;
            }
            if (args.length != cparams.length) continue;
            if (constructor == null) {
                constructor = cconstructor;
                types = cparams;
                continue;
            }
            int point = BeanInfo.calcurateDistance(types, args);
            int cpoint = BeanInfo.calcurateDistance(cparams, args);
            if (cpoint > point) {
                constructor = cconstructor;
                types = cparams;
                continue;
            }
            if (cpoint != point) continue;
            cconstructor = null;
            cparams = null;
        }
        if (vconstructor != null) {
            if (constructor == null) {
                constructor = vconstructor;
            } else {
                int point = BeanInfo.calcurateDistance(types, args);
                int vpoint = BeanInfo.calcurateDistance(vtypes, args);
                if (vpoint > point) {
                    constructor = vconstructor;
                }
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("suitable constructor is not found.");
        }
        return constructor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanClass == null ? 0 : this.beanClass.hashCode());
        result = 31 * result + (this.constructors == null ? 0 : this.constructors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorInfo other = (ConstructorInfo)obj;
        if (this.beanClass == null ? other.beanClass != null : !this.beanClass.equals(other.beanClass)) {
            return false;
        }
        return !(this.constructors == null ? other.constructors != null : !this.constructors.equals(other.constructors));
    }

    public String toString() {
        return "ConstructorInfo [beanClass=" + this.beanClass + ", constructors=" + this.constructors + "]";
    }
}

