/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.util;

import info.aduna.concurrent.locks.Lock;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.openrdf.sail.LockManager;
import org.openrdf.sail.SailLockedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLockManager
implements LockManager {
    private static final String CREATE_LOCKED = "CREATE TABLE locked ( process VARCHAR(128) )";
    private static final String INSERT = "INSERT INTO locked VALUES ('";
    private static final String SELECT = "SELECT process FROM locked";
    private static final String DROP = "DROP TABLE locked";
    Logger logger = LoggerFactory.getLogger(DatabaseLockManager.class);
    private DataSource ds;
    private String user;
    private String password;

    public DatabaseLockManager(DataSource ds) {
        this.ds = ds;
    }

    public DatabaseLockManager(DataSource ds, String user, String password) {
        this.ds = ds;
        this.user = user;
        this.password = password;
    }

    public String getLocation() {
        try {
            Method getUrl = this.ds.getClass().getMethod("getUrl", new Class[0]);
            return getUrl.invoke((Object)this.ds, new Object[0]).toString();
        }
        catch (Exception exception) {
            return this.ds.toString();
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    /*
     * Exception decompiling
     */
    public boolean isLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Lock tryLock() {
        Lock lock = null;
        try {
            Connection con = this.getConnection();
            try {
                Lock lock2;
                Statement st = con.createStatement();
                try {
                    st.execute(CREATE_LOCKED);
                    lock = this.createLock();
                    st.execute(INSERT + this.getProcessName() + "')");
                    lock2 = lock;
                }
                catch (Throwable throwable) {
                    st.close();
                    throw throwable;
                }
                st.close();
                return lock2;
            }
            finally {
                con.close();
            }
        }
        catch (SQLException exc) {
            this.logger.warn(exc.toString(), exc);
            if (lock != null) {
                lock.release();
            }
            return null;
        }
    }

    public Lock lockOrFail() throws SailLockedException {
        Lock lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        String requestedBy = this.getProcessName();
        String lockedBy = this.getLockedBy();
        if (lockedBy != null) {
            throw new SailLockedException(lockedBy, requestedBy, this);
        }
        lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        throw new SailLockedException(requestedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean revokeLock() {
        try {
            Connection con = this.getConnection();
            try {
                boolean bl;
                Statement st = con.createStatement();
                try {
                    st.execute(DROP);
                    bl = true;
                }
                catch (Throwable throwable) {
                    st.close();
                    throw throwable;
                }
                st.close();
                return bl;
            }
            finally {
                con.close();
            }
        }
        catch (SQLException exc) {
            this.logger.warn(exc.toString(), exc);
            return false;
        }
    }

    Connection getConnection() throws SQLException {
        if (this.user == null) {
            return this.ds.getConnection();
        }
        return this.ds.getConnection(this.user, this.password);
    }

    /*
     * Exception decompiling
     */
    private String getLockedBy() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private Lock createLock() {
        return new Lock(){
            private boolean active = true;

            public boolean isActive() {
                return this.active;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release() {
                this.active = false;
                try {
                    Connection con = DatabaseLockManager.this.getConnection();
                    try {
                        Statement st = con.createStatement();
                        try {
                            st.execute(DatabaseLockManager.DROP);
                        }
                        finally {
                            st.close();
                        }
                    }
                    finally {
                        con.close();
                    }
                }
                catch (SQLException exc) {
                    DatabaseLockManager.this.logger.error(exc.toString(), exc);
                }
            }

            protected void finalize() throws Throwable {
                if (this.active) {
                    this.release();
                }
                super.finalize();
            }
        };
    }
}

