/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.ValueType;
import org.openrdf.sail.rdbms.schema.ValueTypes;

public class TripleTable {
    public static int tables_created;
    public static int total_st;
    public static final boolean UNIQUE_INDEX_TRIPLES = true;
    private static final String[] PKEY;
    private static final String[] SUBJ_INDEX;
    private static final String[] CTX_INDEX;
    private static final String[] PRED_PKEY;
    private static final String[] PRED_INDEX;
    private static final String[] EXPL_INDEX;
    private RdbmsTable table;
    private ValueTypes objTypes = new ValueTypes();
    private ValueTypes subjTypes = new ValueTypes();
    private boolean initialize;
    private boolean predColumnPresent;
    private boolean indexed;
    private IdSequence ids;

    public TripleTable(RdbmsTable table) {
        this.table = table;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public boolean isPredColumnPresent() {
        return this.predColumnPresent;
    }

    public void setPredColumnPresent(boolean present) {
        this.predColumnPresent = present;
    }

    public void setIndexed(boolean indexingTriples) {
        this.indexed = true;
    }

    public synchronized void initTable() throws SQLException {
        if (this.initialize) {
            return;
        }
        this.table.createTransactionalTable(this.buildTableColumns());
        ++tables_created;
        ++total_st;
        if (this.isPredColumnPresent()) {
            this.table.primaryIndex(PRED_PKEY);
            ++total_st;
        } else {
            this.table.primaryIndex(PKEY);
            ++total_st;
        }
        if (this.indexed) {
            this.createIndex();
        }
        this.initialize = true;
    }

    public void reload() throws SQLException {
        this.table.count();
        if (this.table.size() > 0L) {
            int i;
            ValueType[] values = ValueType.values();
            String[] OBJ_CONTAINS = new String[values.length];
            String[] SUBJ_CONTAINS = new String[values.length];
            StringBuilder sb = new StringBuilder();
            int n = values.length;
            for (int i2 = 0; i2 < n; ++i2) {
                sb.delete(0, sb.length());
                ValueType code = values[i2];
                sb.append("MAX(CASE WHEN obj BETWEEN ").append(this.ids.minId(code));
                sb.append(" AND ").append(this.ids.maxId(code));
                sb.append(" THEN 1 ELSE 0 END)");
                OBJ_CONTAINS[i2] = sb.toString();
                sb.delete(0, sb.length());
                sb.append("MAX(CASE WHEN subj BETWEEN ").append(this.ids.minId(code));
                sb.append(" AND ").append(this.ids.maxId(code));
                sb.append(" THEN 1 ELSE 0 END)");
                SUBJ_CONTAINS[i2] = sb.toString();
            }
            int[] aggregate = this.table.aggregate(OBJ_CONTAINS);
            for (i = 0; i < aggregate.length; ++i) {
                if (aggregate[i] != 1) continue;
                this.objTypes.add(values[i]);
            }
            aggregate = this.table.aggregate(SUBJ_CONTAINS);
            for (i = 0; i < aggregate.length; ++i) {
                if (aggregate[i] != 1) continue;
                this.subjTypes.add(values[i]);
            }
        }
        this.initialize = true;
    }

    public void close() throws SQLException {
        this.table.close();
    }

    public boolean isIndexed() throws SQLException {
        return this.table.getIndexes().size() > 1;
    }

    public void createIndex() throws SQLException {
        if (this.isPredColumnPresent()) {
            this.table.index(PRED_INDEX);
            ++total_st;
        }
        this.table.index(SUBJ_INDEX);
        ++total_st;
        this.table.index(CTX_INDEX);
        ++total_st;
        this.table.index(EXPL_INDEX);
        ++total_st;
    }

    public void dropIndex() throws SQLException {
        for (Map.Entry<String, List<String>> e2 : this.table.getIndexes().entrySet()) {
            if (e2.getValue().contains("OBJ") || e2.getValue().contains("obj")) continue;
            this.table.dropIndex(e2.getKey());
        }
    }

    public boolean isReady() {
        return this.initialize;
    }

    public void blockUntilReady() throws SQLException {
        if (this.initialize) {
            return;
        }
        this.initTable();
    }

    public String getName() throws SQLException {
        return this.table.getName();
    }

    public String getNameWhenReady() throws SQLException {
        this.blockUntilReady();
        return this.table.getName();
    }

    public ValueTypes getObjTypes() {
        return this.objTypes;
    }

    public void setObjTypes(ValueTypes valueTypes) {
        this.objTypes.merge(valueTypes);
    }

    public ValueTypes getSubjTypes() {
        return this.subjTypes;
    }

    public void setSubjTypes(ValueTypes valueTypes) {
        this.subjTypes.merge(valueTypes);
    }

    public void modified(int addedCount, int removedCount) throws SQLException {
        this.blockUntilReady();
        this.table.modified(addedCount, removedCount);
        this.table.optimize();
        if (this.isEmpty()) {
            this.objTypes.reset();
            this.subjTypes.reset();
        }
    }

    public boolean isEmpty() throws SQLException {
        this.blockUntilReady();
        return this.table.size() == 0L;
    }

    public String toString() {
        return this.table.getName();
    }

    public void drop() throws SQLException {
        this.blockUntilReady();
        this.table.drop();
    }

    protected CharSequence buildTableColumns() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ctx ").append(this.ids.getSqlType()).append(" NOT NULL,\n");
        sb.append("  subj ").append(this.ids.getSqlType()).append(" NOT NULL,\n");
        if (this.isPredColumnPresent()) {
            sb.append("  pred ").append(this.ids.getSqlType()).append(" NOT NULL,\n");
        }
        sb.append("  obj ").append(this.ids.getSqlType()).append(" NOT NULL,\n");
        sb.append("  expl ").append("BOOL").append(" NOT NULL\n");
        return sb;
    }

    static {
        PKEY = new String[]{"obj", "subj", "ctx", "expl"};
        SUBJ_INDEX = new String[]{"subj"};
        CTX_INDEX = new String[]{"ctx"};
        PRED_PKEY = new String[]{"obj", "subj", "pred", "ctx", "expl"};
        PRED_INDEX = new String[]{"pred"};
        EXPL_INDEX = new String[]{"expl"};
    }
}

