/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers.base;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import org.openrdf.sail.rdbms.managers.helpers.BatchBlockingQueue;
import org.openrdf.sail.rdbms.schema.Batch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagerBase {
    public static int BATCH_SIZE = 8192;
    public static int MIN_QUEUE = 128;
    public static int MAX_QUEUE = 98304;
    private static final boolean USE_THREAD = true;
    Exception exc;
    private Logger logger = LoggerFactory.getLogger(ManagerBase.class);
    public final BlockingQueue<Batch> queue = new BatchBlockingQueue(MAX_QUEUE);
    private final Object working = new Object();
    private Batch wb;
    private Thread thread;
    private int count;

    public BlockingQueue<Batch> getQueue() {
        ClassLoader cl = this.getClass().getClassLoader();
        Class[] classes = new Class[]{BlockingQueue.class};
        InvocationHandler h = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke(ManagerBase.this.queue, args);
                ManagerBase.this.checkQueueSize();
                return result;
            }
        };
        Object proxy = Proxy.newProxyInstance(cl, classes, h);
        return (BlockingQueue)proxy;
    }

    public void close() throws SQLException {
        try {
            this.flush();
            if (this.thread != null) {
                this.queue.put(Batch.CLOSED_SIGNAL);
                this.thread.join();
            }
        }
        catch (InterruptedException e2) {
            this.logger.warn(e2.toString(), e2);
        }
        this.throwException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException, InterruptedException {
        this.throwException();
        Object object = this.working;
        synchronized (object) {
            this.throwException();
            Batch b = (Batch)this.queue.poll();
            while (this.isFlushable(b)) {
                this.flush(b);
                b = (Batch)this.queue.poll();
            }
            if (this.wb != null) {
                this.flush(this.wb);
                this.wb = null;
            }
            this.count = 0;
        }
    }

    public void clear() {
        this.queue.clear();
    }

    protected void optimize() throws SQLException {
    }

    void checkQueueSize() {
        if (++this.count >= MIN_QUEUE && this.thread == null) {
            String name = this.getClass().getSimpleName() + "-flusher";
            this.thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ManagerBase.this.insertThread(ManagerBase.this.working);
                    }
                    catch (Exception e2) {
                        ManagerBase.this.exc = e2;
                        ManagerBase.this.logger.error(e2.toString(), e2);
                    }
                }
            }, name);
            this.thread.start();
        }
    }

    protected void flush(Batch batch) throws SQLException {
        batch.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertThread(Object working) throws SQLException, InterruptedException {
        String name = Thread.currentThread().getName();
        this.logger.debug("Starting helper thread {}", (Object)name);
        int notReadyCount = 0;
        this.wb = this.queue.take();
        while (this.isFlushable(this.wb)) {
            if (this.wb.isReady() || this.queue.size() <= notReadyCount) {
                Object object = working;
                synchronized (object) {
                    if (this.wb != null) {
                        this.flush(this.wb);
                        this.wb = null;
                    }
                }
                this.optimize();
                notReadyCount = 0;
            } else {
                this.queue.add(this.wb);
                ++notReadyCount;
            }
            this.wb = this.queue.take();
        }
        this.logger.debug("Closing helper thread {}", (Object)name);
    }

    private boolean isFlushable(Batch batch) {
        return batch != null && batch != Batch.CLOSED_SIGNAL;
    }

    private void throwException() throws SQLException {
        if (this.exc instanceof SQLException) {
            SQLException e2 = (SQLException)this.exc;
            this.exc = null;
            throw e2;
        }
        if (this.exc instanceof RuntimeException) {
            RuntimeException e3 = (RuntimeException)this.exc;
            this.exc = null;
            throw e3;
        }
    }
}

