/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.rdbms.managers.TripleTableManager;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.TableFactory;
import org.openrdf.sail.rdbms.schema.TransactionTable;
import org.openrdf.sail.rdbms.schema.TripleTable;
import org.openrdf.sail.rdbms.schema.ValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransTableManager {
    public static int BATCH_SIZE = 8192;
    public static final boolean TEMPORARY_TABLE_USED = true;
    private TableFactory factory;
    private TripleTableManager triples;
    private RdbmsTable temporaryTable;
    private Map<Number, TransactionTable> tables = new HashMap<Number, TransactionTable>();
    private int removedCount;
    private String fromDummy;
    private Connection conn;
    private BlockingQueue<Batch> batchQueue;
    private DefaultSailChangedEvent sailChangedEvent;
    private IdSequence ids;

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setTemporaryTableFactory(TableFactory factory) {
        this.factory = factory;
    }

    public void setStatementsTable(TripleTableManager predicateTableManager) {
        this.triples = predicateTableManager;
    }

    public void setFromDummyTable(String fromDummy) {
        this.fromDummy = fromDummy;
    }

    public void setBatchQueue(BlockingQueue<Batch> queue) {
        this.batchQueue = queue;
    }

    public void setSailChangedEvent(DefaultSailChangedEvent sailChangedEvent) {
        this.sailChangedEvent = sailChangedEvent;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public int getBatchSize() {
        return BATCH_SIZE;
    }

    public void initialize() throws SQLException {
    }

    public void insert(Number ctx, Number subj, Number pred, Number obj) throws SQLException, InterruptedException {
        this.getTable(pred).insert(ctx, subj, pred, obj);
    }

    public void close() throws SQLException {
        try {
            if (this.temporaryTable != null) {
                this.temporaryTable.drop();
                this.temporaryTable.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        for (TransactionTable table : this.tables.values()) {
            table.close();
        }
    }

    public String findTableName(Number pred) throws SQLException {
        return this.triples.findTableName(pred);
    }

    public String getCombinedTableName() throws SQLException {
        String union = " UNION ALL ";
        StringBuilder sb = new StringBuilder(1024);
        sb.append("(");
        for (Number pred : this.triples.getPredicateIds()) {
            TripleTable predicate;
            try {
                predicate = this.triples.getPredicateTable(pred);
            }
            catch (SQLException e2) {
                throw new AssertionError((Object)e2);
            }
            TransactionTable table = this.findTable(pred);
            if ((table == null || table.isEmpty()) && predicate.isEmpty()) continue;
            sb.append("SELECT ctx, subj, ");
            if (predicate.isPredColumnPresent()) {
                sb.append(" pred,");
            } else {
                sb.append(pred).append(" AS pred,");
            }
            sb.append(" obj");
            sb.append("\nFROM ");
            sb.append(predicate.getNameWhenReady());
            sb.append(union);
            predicate.blockUntilReady();
        }
        if (sb.length() < union.length()) {
            return this.getEmptyTableName();
        }
        sb.delete(sb.length() - union.length(), sb.length());
        sb.append(")");
        return sb.toString();
    }

    public String getTableName(Number pred) throws SQLException {
        if (pred.equals(0L)) {
            return this.getCombinedTableName();
        }
        String tableName = this.triples.getTableName(pred);
        if (tableName == null) {
            return this.getEmptyTableName();
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void committed(boolean locked) throws SQLException {
        Map<Number, TransactionTable> map = this.tables;
        synchronized (map) {
            for (TransactionTable table : this.tables.values()) {
                table.committed();
            }
            this.tables.clear();
        }
        if (this.removedCount > 0) {
            this.triples.removed(this.removedCount, locked);
        }
    }

    public void removed(Number pred, int count) throws SQLException {
        this.getTable(pred).removed(count);
        this.removedCount += count;
    }

    public Collection<Number> getPredicateIds() {
        return this.triples.getPredicateIds();
    }

    public boolean isPredColumnPresent(Number id) throws SQLException {
        if (id.longValue() == 0L) {
            return true;
        }
        return this.triples.getPredicateTable(id).isPredColumnPresent();
    }

    public ValueTypes getObjTypes(Number pred) {
        TripleTable table = this.triples.getExistingTable(pred);
        if (table == null) {
            return ValueTypes.UNKNOWN;
        }
        return table.getObjTypes();
    }

    public ValueTypes getSubjTypes(Number pred) {
        TripleTable table = this.triples.getExistingTable(pred);
        if (table == null) {
            return ValueTypes.RESOURCE;
        }
        return table.getSubjTypes();
    }

    public boolean isEmpty() throws SQLException {
        for (Number pred : this.triples.getPredicateIds()) {
            TripleTable predicate;
            try {
                predicate = this.triples.getPredicateTable(pred);
            }
            catch (SQLException e2) {
                throw new AssertionError((Object)e2);
            }
            TransactionTable table = this.findTable(pred);
            if ((table == null || table.isEmpty()) && predicate.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected String getZeroBigInt() {
        return "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionTable getTable(Number pred) throws SQLException {
        Map<Number, TransactionTable> map = this.tables;
        synchronized (map) {
            TransactionTable table = this.tables.get(pred);
            if (table == null) {
                TripleTable predicate = this.triples.getPredicateTable(pred);
                Number key = pred;
                if (predicate.isPredColumnPresent() && (table = this.tables.get(key = this.ids.idOf(-1))) != null) {
                    return table;
                }
                table = this.createTransactionTable(predicate);
                this.tables.put(key, table);
            }
            return table;
        }
    }

    protected TransactionTable createTransactionTable(TripleTable predicate) throws SQLException {
        if (this.temporaryTable == null) {
            this.temporaryTable = this.createTemporaryTable(this.conn);
            if (!this.temporaryTable.isCreated()) {
                this.createTemporaryTable(this.temporaryTable);
            }
        }
        TransactionTable table = this.createTransactionTable();
        table.setIdSequence(this.ids);
        table.setSailChangedEvent(this.sailChangedEvent);
        table.setQueue(this.batchQueue);
        table.setTripleTable(predicate);
        table.setTemporaryTable(this.temporaryTable);
        table.setConnection(this.conn);
        table.setBatchSize(this.getBatchSize());
        return table;
    }

    protected RdbmsTable createTemporaryTable(Connection conn) {
        return this.factory.createTemporaryTable(conn);
    }

    protected TransactionTable createTransactionTable() {
        return new TransactionTable();
    }

    protected void createTemporaryTable(RdbmsTable table) throws SQLException {
        String type = this.ids.getSqlType();
        StringBuilder sb = new StringBuilder();
        sb.append("  ctx ").append(type).append(" NOT NULL,\n");
        sb.append("  subj ").append(type).append(" NOT NULL,\n");
        sb.append("  pred ").append(type).append(" NOT NULL,\n");
        sb.append("  obj ").append(type).append(" NOT NULL,\n");
        sb.append("  expl ").append("BOOL").append(" NOT NULL\n");
        table.createTemporaryTable(sb);
    }

    private String getEmptyTableName() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("(");
        sb.append("SELECT ");
        sb.append(this.getZeroBigInt()).append(" AS ctx, ");
        sb.append(this.getZeroBigInt()).append(" AS subj, ");
        sb.append(this.getZeroBigInt()).append(" AS pred, ");
        sb.append(this.getZeroBigInt()).append(" AS obj ");
        sb.append(this.fromDummy);
        sb.append("\nWHERE 1=0");
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionTable findTable(Number pred) {
        Map<Number, TransactionTable> map = this.tables;
        synchronized (map) {
            return this.tables.get(pred);
        }
    }
}

