/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.SailException;
import org.openrdf.sail.rdbms.RdbmsTripleRepository;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;

public class RdbmsTripleSource
implements TripleSource {
    private RdbmsTripleRepository triples;

    public RdbmsTripleSource(RdbmsTripleRepository triples) {
        this.triples = triples;
    }

    public RdbmsValueFactory getValueFactory() {
        return this.triples.getValueFactory();
    }

    public CloseableIteration getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        try {
            RdbmsValueFactory vf = this.triples.getValueFactory();
            RdbmsResource s = vf.asRdbmsResource(subj);
            RdbmsURI p = vf.asRdbmsURI(pred);
            RdbmsValue o = vf.asRdbmsValue(obj);
            Resource[] c = vf.asRdbmsResource(contexts);
            return this.triples.find(s, p, o, c);
        }
        catch (SailException e2) {
            throw new QueryEvaluationException(e2);
        }
    }
}

