/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.evaluation.QueryBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlBracketBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlCastBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlJoinBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlQueryBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlRegexBuilder;

public class QueryBuilderFactory {
    private RdbmsValueFactory vf;
    private boolean usingHashTable;

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public void setUsingHashTable(boolean b) {
        this.usingHashTable = b;
    }

    public QueryBuilder createQueryBuilder() {
        QueryBuilder query2 = new QueryBuilder(this.createSqlQueryBuilder());
        query2.setValueFactory(this.vf);
        query2.setUsingHashTable(this.usingHashTable);
        return query2;
    }

    public SqlQueryBuilder createSqlQueryBuilder() {
        return new SqlQueryBuilder(this);
    }

    public SqlExprBuilder createSqlExprBuilder() {
        return new SqlExprBuilder(this);
    }

    public SqlRegexBuilder createSqlRegexBuilder(SqlExprBuilder where) {
        return new SqlRegexBuilder(where, this);
    }

    public SqlBracketBuilder createSqlBracketBuilder(SqlExprBuilder where) {
        return new SqlBracketBuilder(where, this);
    }

    public SqlJoinBuilder createSqlJoinBuilder(String table, String alias) {
        return new SqlJoinBuilder(table, alias, this);
    }

    public SqlCastBuilder createSqlCastBuilder(SqlExprBuilder where, int type) {
        return new SqlCastBuilder(where, this, type);
    }
}

