/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.base;

import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.sail.rdbms.algebra.DoubleValue;
import org.openrdf.sail.rdbms.algebra.FalseValue;
import org.openrdf.sail.rdbms.algebra.SqlAbs;
import org.openrdf.sail.rdbms.algebra.SqlAnd;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlCast;
import org.openrdf.sail.rdbms.algebra.SqlCompare;
import org.openrdf.sail.rdbms.algebra.SqlConcat;
import org.openrdf.sail.rdbms.algebra.SqlEq;
import org.openrdf.sail.rdbms.algebra.SqlIsNull;
import org.openrdf.sail.rdbms.algebra.SqlLike;
import org.openrdf.sail.rdbms.algebra.SqlLowerCase;
import org.openrdf.sail.rdbms.algebra.SqlMathExpr;
import org.openrdf.sail.rdbms.algebra.SqlNot;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.SqlOr;
import org.openrdf.sail.rdbms.algebra.SqlRegex;
import org.openrdf.sail.rdbms.algebra.StringValue;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

public class SqlExprSupport {
    public static SqlExpr abs(SqlExpr arg) {
        return new SqlAbs(arg);
    }

    public static SqlExpr and(SqlExpr left, SqlExpr right) {
        return new SqlAnd(left, right);
    }

    public static SqlExpr cmp(SqlExpr left, Compare.CompareOp op, SqlExpr right) {
        return new SqlCompare(left, op, right);
    }

    public static SqlExpr coalesce(SqlExpr ... exprs) {
        SqlCase sqlCase = new SqlCase();
        for (SqlExpr expr : exprs) {
            sqlCase.when(SqlExprSupport.isNotNull(expr.clone()), expr);
        }
        return sqlCase;
    }

    public static SqlExpr concat(SqlExpr left, SqlExpr right) {
        return new SqlConcat(left, right);
    }

    public static SqlExpr eq(SqlExpr left, SqlExpr right) {
        return new SqlEq(left, right);
    }

    public static SqlExpr eqComparingNull(SqlExpr left, SqlExpr right) {
        SqlExpr leftIsNull = SqlExprSupport.isNull(left.clone());
        SqlExpr rightIsNull = SqlExprSupport.isNull(right.clone());
        SqlExpr bothNull = SqlExprSupport.and(leftIsNull, rightIsNull);
        SqlExpr bothNotNull = SqlExprSupport.and(SqlExprSupport.not(leftIsNull), SqlExprSupport.not(rightIsNull));
        return SqlExprSupport.or(bothNull, SqlExprSupport.and(bothNotNull, SqlExprSupport.eq(left, right)));
    }

    public static SqlExpr eqIfNotNull(SqlExpr left, SqlExpr right) {
        SqlExpr leftIsNotNull = SqlExprSupport.isNotNull(left.clone());
        SqlExpr rightIsNotNull = SqlExprSupport.isNotNull(right.clone());
        SqlExpr bothNotNull = SqlExprSupport.and(leftIsNotNull, rightIsNotNull);
        return SqlExprSupport.and(bothNotNull, SqlExprSupport.eq(left, right));
    }

    public static SqlExpr eqOrBothNull(SqlExpr left, SqlExpr right) {
        SqlExpr leftIsNull = SqlExprSupport.isNull(left.clone());
        SqlExpr rightIsNull = SqlExprSupport.isNull(right.clone());
        SqlExpr bothNull = SqlExprSupport.and(leftIsNull, rightIsNull);
        return SqlExprSupport.or(bothNull, SqlExprSupport.eq(left, right));
    }

    public static SqlExpr eqOrSimpleType(SqlExpr left, SqlExpr right) {
        SqlExpr bothSimple = SqlExprSupport.and(SqlExprSupport.simple(left), SqlExprSupport.simple(right));
        return SqlExprSupport.or(SqlExprSupport.eq(left.clone(), right.clone()), bothSimple);
    }

    public static SqlExpr ge(SqlExpr left, SqlExpr right) {
        return new SqlCompare(left, Compare.CompareOp.GE, right);
    }

    public static SqlExpr gt(SqlExpr left, SqlExpr right) {
        return new SqlCompare(left, Compare.CompareOp.GT, right);
    }

    public static SqlExpr in(SqlExpr compare, SqlExpr ... values) {
        SqlExpr expr = null;
        for (SqlExpr value : values) {
            expr = expr == null ? new SqlEq(compare, value) : SqlExprSupport.or(expr, new SqlEq(compare.clone(), value));
        }
        if (expr == null) {
            return new FalseValue();
        }
        return expr;
    }

    public static SqlExpr isNotNull(SqlExpr arg) {
        return SqlExprSupport.not(SqlExprSupport.isNull(arg));
    }

    public static SqlExpr isNull(SqlExpr arg) {
        return new SqlIsNull(arg);
    }

    public static SqlExpr le(SqlExpr left, SqlExpr right) {
        return new SqlCompare(left, Compare.CompareOp.LE, right);
    }

    public static SqlExpr like(SqlExpr left, SqlExpr right) {
        return new SqlLike(left, right);
    }

    public static SqlExpr lowercase(SqlExpr arg) {
        return new SqlLowerCase(arg);
    }

    public static SqlExpr lt(SqlExpr left, SqlExpr right) {
        return new SqlCompare(left, Compare.CompareOp.LT, right);
    }

    public static SqlExpr neq(SqlExpr left, SqlExpr right) {
        return new SqlNot(new SqlEq(left, right));
    }

    public static SqlExpr neqComparingNull(SqlExpr left, SqlExpr right) {
        SqlExpr leftIsNull = SqlExprSupport.isNull(left.clone());
        SqlExpr rightIsNull = SqlExprSupport.isNull(right.clone());
        SqlExpr onlyLeftIsNull = SqlExprSupport.and(SqlExprSupport.not(leftIsNull), rightIsNull.clone());
        SqlExpr onlyRightIsNull = SqlExprSupport.and(leftIsNull.clone(), SqlExprSupport.not(rightIsNull));
        SqlExpr compareNull = SqlExprSupport.or(onlyRightIsNull, onlyLeftIsNull);
        return SqlExprSupport.or(SqlExprSupport.not(SqlExprSupport.eq(left, right)), compareNull);
    }

    public static SqlExpr not(SqlExpr arg) {
        return new SqlNot(arg);
    }

    public static SqlExpr num(double value) {
        return new DoubleValue(value);
    }

    public static SqlExpr or(SqlExpr left, SqlExpr right) {
        return new SqlOr(left, right);
    }

    public static SqlExpr regex(SqlExpr value, SqlExpr pattern) {
        return new SqlRegex(value, pattern);
    }

    public static SqlExpr regex(SqlExpr value, SqlExpr pattern, SqlExpr flags) {
        return new SqlRegex(value, pattern, flags);
    }

    public static SqlExpr simple(SqlExpr arg) {
        SqlExpr isString = SqlExprSupport.eq(arg.clone(), SqlExprSupport.str(XMLSchema.STRING));
        return SqlExprSupport.or(SqlExprSupport.isNull(arg.clone()), isString);
    }

    public static SqlExpr sqlNull() {
        return new SqlNull();
    }

    public static SqlExpr str(String str2) {
        if (str2 == null) {
            return SqlExprSupport.sqlNull();
        }
        return new StringValue(str2);
    }

    public static SqlExpr str(URI uri) {
        return new StringValue(uri.stringValue());
    }

    public static SqlExpr sub(SqlExpr left, SqlExpr right) {
        return new SqlMathExpr(left, MathExpr.MathOp.MINUS, right);
    }

    public static SqlExpr text(SqlExpr arg) {
        return new SqlCast(arg, 12);
    }

    public static UnsupportedRdbmsOperatorException unsupported(Object arg) {
        return new UnsupportedRdbmsOperatorException(arg.toString());
    }

    private SqlExprSupport() {
    }
}

