/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCase
extends RdbmsQueryModelNodeBase
implements SqlExpr {
    private List<Entry> entries = new ArrayList<Entry>();

    public void when(SqlExpr condition, SqlExpr expr) {
        this.entries.add(new Entry(condition, expr));
        condition.setParentNode(this);
        expr.setParentNode(this);
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (Entry e2 : this.entries) {
            e2.getCondition().visit(visitor);
            e2.getResult().visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        for (Entry e2 : this.entries) {
            if (e2.getCondition() == current) {
                e2.setCondition((SqlExpr)replacement);
                continue;
            }
            if (e2.getResult() != current) continue;
            e2.setResult((SqlExpr)replacement);
        }
    }

    @Override
    public SqlCase clone() {
        SqlCase clone = (SqlCase)super.clone();
        clone.entries = new ArrayList<Entry>();
        for (Entry e2 : this.entries) {
            clone.when(e2.getCondition().clone(), e2.getResult().clone());
        }
        return clone;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    public void removeEntry(Entry e2) {
        this.entries.remove(e2);
    }

    public void truncateEntries(Entry e2) {
        int idx = this.entries.indexOf(e2) + 1;
        if (idx < this.entries.size()) {
            this.entries = this.entries.subList(0, idx);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : ((Object)this.entries).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlCase other = (SqlCase)obj;
        return !(this.entries == null ? other.entries != null : !((Object)this.entries).equals(other.entries));
    }

    public class Entry {
        private SqlExpr condition;
        private SqlExpr result;

        public Entry(SqlExpr condition, SqlExpr result) {
            this.condition = condition;
            this.result = result;
        }

        public SqlExpr getCondition() {
            return this.condition;
        }

        public void setCondition(SqlExpr condition) {
            this.condition = condition;
            condition.setParentNode(SqlCase.this);
        }

        public SqlExpr getResult() {
            return this.result;
        }

        public void setResult(SqlExpr result) {
            this.result = result;
            result.setParentNode(SqlCase.this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
                return false;
            }
            return !(this.result == null ? other.result != null : !this.result.equals(other.result));
        }
    }
}

