/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms;

import info.aduna.concurrent.locks.Lock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlBracketBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlJoinBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlQueryBuilder;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.iteration.EmptyRdbmsResourceIteration;
import org.openrdf.sail.rdbms.iteration.EmptyRdbmsStatementIteration;
import org.openrdf.sail.rdbms.iteration.RdbmsResourceIteration;
import org.openrdf.sail.rdbms.iteration.RdbmsStatementIteration;
import org.openrdf.sail.rdbms.managers.TransTableManager;
import org.openrdf.sail.rdbms.managers.TripleManager;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsStatement;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.BNodeTable;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.LiteralTable;
import org.openrdf.sail.rdbms.schema.URITable;

public class RdbmsTripleRepository {
    public static int STMT_BUFFER = 32;
    private Connection conn;
    private RdbmsValueFactory vf;
    private TransTableManager statements;
    private QueryBuilderFactory factory;
    private BNodeTable bnodes;
    private URITable uris;
    private LiteralTable literals;
    private Lock readLock;
    private DefaultSailChangedEvent sailChangedEvent;
    private TripleManager manager;
    private LinkedList<RdbmsStatement> queue = new LinkedList();
    private IdSequence ids;

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public RdbmsValueFactory getValueFactory() {
        return this.vf;
    }

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public DefaultSailChangedEvent getSailChangedEvent() {
        return this.sailChangedEvent;
    }

    public void setSailChangedEvent(DefaultSailChangedEvent sailChangedEvent) {
        this.sailChangedEvent = sailChangedEvent;
    }

    public void setQueryBuilderFactory(QueryBuilderFactory factory) {
        this.factory = factory;
    }

    public void setBNodeTable(BNodeTable bnodes) {
        this.bnodes = bnodes;
    }

    public void setURITable(URITable uris) {
        this.uris = uris;
    }

    public void setLiteralTable(LiteralTable literals) {
        this.literals = literals;
    }

    public void setTransaction(TransTableManager temporary) {
        this.statements = temporary;
    }

    public void setTripleManager(TripleManager tripleManager) {
        this.manager = tripleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws RdbmsException {
        try {
            LinkedList<RdbmsStatement> linkedList = this.queue;
            synchronized (linkedList) {
                while (!this.queue.isEmpty()) {
                    this.insert(this.queue.removeFirst());
                }
            }
            this.vf.flush();
            this.manager.flush();
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
        catch (InterruptedException e3) {
            throw new RdbmsException(e3);
        }
    }

    public synchronized void begin() throws SQLException {
        this.conn.setAutoCommit(false);
    }

    public synchronized void close() throws SQLException {
        this.manager.close();
        if (!this.conn.getAutoCommit()) {
            this.conn.rollback();
        }
        this.conn.setAutoCommit(true);
        this.conn.close();
        this.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws SQLException, RdbmsException, InterruptedException {
        LinkedList<RdbmsStatement> linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.queue.isEmpty()) {
                this.insert(this.queue.removeFirst());
            }
        }
        this.manager.flush();
        this.conn.commit();
        this.conn.setAutoCommit(true);
        this.releaseLock();
        Lock writeLock = this.vf.tryIdWriteLock();
        try {
            this.vf.flush();
            this.statements.committed(writeLock != null);
        }
        finally {
            if (writeLock != null) {
                writeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException, SailException {
        LinkedList<RdbmsStatement> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
        this.manager.clear();
        if (!this.conn.getAutoCommit()) {
            this.conn.rollback();
            this.conn.setAutoCommit(true);
        }
        this.releaseLock();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RdbmsStatement st) throws SailException, SQLException, InterruptedException {
        this.acquireLock();
        LinkedList<RdbmsStatement> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(st);
            if (this.queue.size() > this.getMaxQueueSize()) {
                this.insert(this.queue.removeFirst());
            }
        }
    }

    public RdbmsStatementIteration find(Resource subj, URI pred, Value obj, Resource ... ctxs) throws RdbmsException {
        try {
            RdbmsResource s = this.vf.asRdbmsResource(subj);
            RdbmsURI p = this.vf.asRdbmsURI(pred);
            RdbmsValue o = this.vf.asRdbmsValue(obj);
            RdbmsResource[] c = this.vf.asRdbmsResource(ctxs);
            this.flush();
            SqlQueryBuilder query2 = this.buildSelectQuery(s, p, o, c);
            if (query2 == null) {
                return new EmptyRdbmsStatementIteration();
            }
            List<Object> parameters = query2.findParameters(new ArrayList<Object>());
            PreparedStatement stmt = this.conn.prepareStatement(query2.toString());
            try {
                int n = parameters.size();
                for (int i = 0; i < n; ++i) {
                    stmt.setObject(i + 1, parameters.get(i));
                }
                return new RdbmsStatementIteration(this.vf, stmt, this.ids);
            }
            catch (SQLException e2) {
                stmt.close();
                throw e2;
            }
        }
        catch (SQLException e3) {
            throw new RdbmsException(e3);
        }
    }

    public RdbmsResourceIteration findContexts() throws SQLException, RdbmsException {
        this.flush();
        String qry = this.buildContextQuery();
        if (qry == null) {
            return new EmptyRdbmsResourceIteration();
        }
        PreparedStatement stmt = this.conn.prepareStatement(qry);
        try {
            return new RdbmsResourceIteration(this.vf, stmt);
        }
        catch (SQLException e2) {
            stmt.close();
            throw e2;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(Resource subj, URI pred, Value obj, Resource ... ctxs) throws RdbmsException {
        RdbmsResource s = this.vf.asRdbmsResource(subj);
        RdbmsURI p = this.vf.asRdbmsURI(pred);
        RdbmsValue o = this.vf.asRdbmsValue(obj);
        RdbmsResource[] c = this.vf.asRdbmsResource(ctxs);
        this.flush();
        try {
            Collection<Number> predicates = p == null ? this.statements.getPredicateIds() : Collections.singleton(this.vf.getInternalId(p));
            int total = 0;
            for (Number id : predicates) {
                String tableName = this.statements.findTableName(id);
                if (!this.statements.isPredColumnPresent(id)) {
                    p = null;
                }
                String query2 = this.buildDeleteQuery(tableName, s, p, o, c);
                PreparedStatement stmt = this.conn.prepareStatement(query2);
                try {
                    this.setSelectQuery(stmt, s, p, o, c);
                    int count = stmt.executeUpdate();
                    this.statements.removed(id, count);
                    total += count;
                }
                finally {
                    stmt.close();
                }
            }
            if (total > 0) {
                this.sailChangedEvent.setStatementsRemoved(true);
            }
            return total;
        }
        catch (SQLException e2) {
            throw new RdbmsException(e2);
        }
    }

    public long size(RdbmsResource ... ctxs) throws SQLException, SailException {
        this.flush();
        String qry = this.buildCountQuery(ctxs);
        if (qry == null) {
            return 0L;
        }
        PreparedStatement stmt = this.conn.prepareStatement(qry);
        try {
            this.setCountQuery(stmt, ctxs);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
                throw new RdbmsException("Could not determine size");
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    protected int getMaxQueueSize() {
        return STMT_BUFFER;
    }

    private synchronized void acquireLock() throws InterruptedException {
        if (this.readLock == null) {
            this.readLock = this.vf.getIdReadLock();
        }
    }

    private synchronized void releaseLock() {
        if (this.readLock != null) {
            this.readLock.release();
            this.readLock = null;
        }
    }

    private String buildContextQuery() throws SQLException {
        if (this.statements.isEmpty()) {
            return null;
        }
        String tableName = this.statements.getCombinedTableName();
        SqlQueryBuilder query2 = this.factory.createSqlQueryBuilder();
        query2.select().column("t", "ctx");
        query2.select().append("CASE WHEN MIN(u.value) IS NOT NULL THEN MIN(u.value) ELSE MIN(b.value) END");
        SqlJoinBuilder join = query2.from(tableName, "t");
        join.leftjoin(this.bnodes.getName(), "b").on("id", "t.ctx");
        join.leftjoin(this.uris.getShortTableName(), "u").on("id", "t.ctx");
        SqlBracketBuilder open = query2.filter().and().open();
        open.column("u", "value").isNotNull();
        open.or();
        open.column("b", "value").isNotNull();
        open.close();
        query2.groupBy("t.ctx");
        return query2.toString();
    }

    private String buildCountQuery(RdbmsResource ... ctxs) throws SQLException {
        String tableName = this.statements.getCombinedTableName();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*) FROM ");
        sb.append(tableName).append(" t");
        if (ctxs != null && ctxs.length > 0) {
            sb.append("\nWHERE ");
            for (int i = 0; i < ctxs.length; ++i) {
                sb.append("t.ctx = ?");
                if (i >= ctxs.length - 1) continue;
                sb.append(" OR ");
            }
        }
        return sb.toString();
    }

    private String buildDeleteQuery(String tableName, RdbmsResource subj, RdbmsURI pred, RdbmsValue obj, RdbmsResource ... ctxs) throws RdbmsException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(tableName);
        return this.buildWhere(sb, subj, pred, obj, ctxs);
    }

    private SqlQueryBuilder buildSelectQuery(RdbmsResource subj, RdbmsURI pred, RdbmsValue obj, RdbmsResource ... ctxs) throws RdbmsException, SQLException {
        Number id;
        SqlJoinBuilder join;
        String tableName = this.statements.getTableName(this.vf.getInternalId(pred));
        SqlQueryBuilder query2 = this.factory.createSqlQueryBuilder();
        query2.select().column("t", "ctx");
        query2.select().append("CASE WHEN cu.value IS NOT NULL THEN cu.value WHEN clu.value IS NOT NULL THEN clu.value ELSE cb.value END");
        query2.select().column("t", "subj");
        query2.select().append("CASE WHEN su.value IS NOT NULL THEN su.value WHEN slu.value IS NOT NULL THEN slu.value ELSE sb.value END");
        query2.select().column("pu", "id");
        query2.select().column("pu", "value");
        query2.select().column("t", "obj");
        query2.select().append("CASE WHEN ou.value IS NOT NULL THEN ou.value WHEN olu.value IS NOT NULL THEN olu.value WHEN ob.value IS NOT NULL THEN ob.value WHEN ol.value IS NOT NULL THEN ol.value ELSE oll.value END");
        query2.select().column("od", "value");
        query2.select().column("og", "value");
        if (pred != null) {
            join = query2.from(this.uris.getShortTableName(), "pu");
            join = join.join(tableName, "t");
        } else {
            join = query2.from(tableName, "t");
        }
        if (pred == null) {
            join.join(this.uris.getShortTableName(), "pu").on("id", "t.pred");
        }
        join.leftjoin(this.uris.getShortTableName(), "cu").on("id", "t.ctx");
        join.leftjoin(this.uris.getLongTableName(), "clu").on("id", "t.ctx");
        join.leftjoin(this.bnodes.getName(), "cb").on("id", "t.ctx");
        join.leftjoin(this.uris.getShortTableName(), "su").on("id", "t.subj");
        join.leftjoin(this.uris.getLongTableName(), "slu").on("id", "t.subj");
        join.leftjoin(this.bnodes.getName(), "sb").on("id", "t.subj");
        join.leftjoin(this.uris.getShortTableName(), "ou").on("id", "t.obj");
        join.leftjoin(this.uris.getLongTableName(), "olu").on("id", "t.obj");
        join.leftjoin(this.bnodes.getName(), "ob").on("id", "t.obj");
        join.leftjoin(this.literals.getLabelTable().getName(), "ol").on("id", "t.obj");
        join.leftjoin(this.literals.getLongLabelTable().getName(), "oll").on("id", "t.obj");
        join.leftjoin(this.literals.getLanguageTable().getName(), "og").on("id", "t.obj");
        join.leftjoin(this.literals.getDatatypeTable().getName(), "od").on("id", "t.obj");
        if (ctxs != null && ctxs.length > 0) {
            Number[] ids = new Number[ctxs.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = this.vf.getInternalId(ctxs[i]);
            }
            query2.filter().and().columnIn("t", "ctx", ids);
        }
        if (subj != null) {
            id = this.vf.getInternalId(subj);
            query2.filter().and().columnEquals("t", "subj", id);
        }
        if (pred != null) {
            id = this.vf.getInternalId(pred);
            query2.filter().and().columnEquals("pu", "id", id);
            if (this.statements.isPredColumnPresent(id)) {
                query2.filter().and().columnEquals("t", "pred", id);
            }
        }
        if (obj != null) {
            id = this.vf.getInternalId(obj);
            query2.filter().and().columnEquals("t", "obj", id);
        }
        return query2;
    }

    private String buildWhere(StringBuilder sb, RdbmsResource subj, RdbmsURI pred, RdbmsValue obj, RdbmsResource ... ctxs) {
        sb.append("\nWHERE 1=1");
        if (ctxs != null && ctxs.length > 0) {
            sb.append(" AND (");
            for (int i = 0; i < ctxs.length; ++i) {
                sb.append("ctx = ?");
                if (i >= ctxs.length - 1) continue;
                sb.append(" OR ");
            }
            sb.append(")");
        }
        if (subj != null) {
            sb.append(" AND subj = ?");
        }
        if (pred != null) {
            sb.append(" AND pred = ?");
        }
        if (obj != null) {
            sb.append(" AND obj = ?");
        }
        return sb.toString();
    }

    private void insert(RdbmsStatement st) throws RdbmsException, SQLException, InterruptedException {
        Number ctx = this.vf.getInternalId(st.getContext());
        Number subj = this.vf.getInternalId(st.getSubject());
        Number pred = this.vf.getPredicateId(st.getPredicate());
        Number obj = this.vf.getInternalId(st.getObject());
        this.manager.insert(ctx, subj, pred, obj);
    }

    private void setCountQuery(PreparedStatement stmt, RdbmsResource ... ctxs) throws SQLException, RdbmsException {
        if (ctxs != null && ctxs.length > 0) {
            for (int i = 0; i < ctxs.length; ++i) {
                stmt.setObject(i + 1, this.vf.getInternalId(ctxs[i]));
            }
        }
    }

    private void setSelectQuery(PreparedStatement stmt, RdbmsResource subj, RdbmsURI pred, RdbmsValue obj, RdbmsResource ... ctxs) throws SQLException, RdbmsException {
        int p = 0;
        if (ctxs != null && ctxs.length > 0) {
            for (int i = 0; i < ctxs.length; ++i) {
                if (ctxs[i] == null) {
                    stmt.setLong(++p, 0L);
                    continue;
                }
                stmt.setObject(++p, this.vf.getInternalId(ctxs[i]));
            }
        }
        if (subj != null) {
            stmt.setObject(++p, this.vf.getInternalId(subj));
        }
        if (pred != null) {
            stmt.setObject(++p, this.vf.getInternalId(pred));
        }
        if (obj != null) {
            stmt.setObject(++p, this.vf.getInternalId(obj));
        }
    }
}

