/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.concurrent.locks.WritePrefReadWriteLockManager;
import info.aduna.io.ByteArrayUtil;
import java.io.File;
import java.io.IOException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryBase;
import org.openrdf.sail.nativerdf.LRUCache;
import org.openrdf.sail.nativerdf.ValueStoreRevision;
import org.openrdf.sail.nativerdf.datastore.DataStore;
import org.openrdf.sail.nativerdf.model.NativeBNode;
import org.openrdf.sail.nativerdf.model.NativeLiteral;
import org.openrdf.sail.nativerdf.model.NativeResource;
import org.openrdf.sail.nativerdf.model.NativeURI;
import org.openrdf.sail.nativerdf.model.NativeValue;

public class ValueStore
extends ValueFactoryBase {
    public static final int VALUE_CACHE_SIZE = 512;
    public static final int VALUE_ID_CACHE_SIZE = 128;
    public static final int NAMESPACE_CACHE_SIZE = 64;
    public static final int NAMESPACE_ID_CACHE_SIZE = 32;
    private static final String FILENAME_PREFIX = "values";
    private static final byte VALUE_TYPE_MASK = 3;
    private static final byte URI_VALUE = 1;
    private static final byte BNODE_VALUE = 2;
    private static final byte LITERAL_VALUE = 3;
    private final DataStore dataStore;
    private final ReadWriteLockManager lockManager = new WritePrefReadWriteLockManager();
    private volatile ValueStoreRevision revision;
    private final LRUCache<Integer, NativeValue> valueCache;
    private final LRUCache<NativeValue, Integer> valueIDCache;
    private final LRUCache<Integer, String> namespaceCache;
    private final LRUCache<String, Integer> namespaceIDCache;

    public ValueStore(File dataDir) throws IOException {
        this(dataDir, false);
    }

    public ValueStore(File dataDir, boolean forceSync) throws IOException {
        this(dataDir, forceSync, 512, 128, 64, 32);
    }

    public ValueStore(File dataDir, boolean forceSync, int valueCacheSize, int valueIDCacheSize, int namespaceCacheSize, int namespaceIDCacheSize) throws IOException {
        this.dataStore = new DataStore(dataDir, FILENAME_PREFIX, forceSync);
        this.valueCache = new LRUCache(valueCacheSize);
        this.valueIDCache = new LRUCache(valueIDCacheSize);
        this.namespaceCache = new LRUCache(namespaceCacheSize);
        this.namespaceIDCache = new LRUCache(namespaceIDCacheSize);
        this.setNewRevision();
    }

    private void setNewRevision() {
        this.revision = new ValueStoreRevision(this);
    }

    public ValueStoreRevision getRevision() {
        return this.revision;
    }

    public Lock getReadLock() throws InterruptedException {
        return this.lockManager.getReadLock();
    }

    public NativeValue getValue(int id) throws IOException {
        byte[] data;
        Integer cacheID = new Integer(id);
        NativeValue resultValue = this.valueCache.get(cacheID);
        if (resultValue == null && (data = this.dataStore.getData(id)) != null) {
            resultValue = this.data2value(id, data);
            this.valueCache.put(cacheID, resultValue);
        }
        return resultValue;
    }

    public int getID(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue = this.isOwnValue(value);
        if (isOwnValue && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            return id;
        }
        byte[] data = this.value2data(value, false);
        if (data != null) {
            int id2 = this.dataStore.getID(data);
            if (id2 != -1) {
                if (isOwnValue) {
                    ((NativeValue)value).setInternalID(id2, this.revision);
                } else {
                    NativeValue nv = this.getNativeValue(value);
                    nv.setInternalID(id2, this.revision);
                    this.valueIDCache.put(nv, new Integer(id2));
                }
            }
            return id2;
        }
        return -1;
    }

    public int storeValue(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue = this.isOwnValue(value);
        if (isOwnValue && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            return id;
        }
        byte[] valueData = this.value2data(value, true);
        int id2 = this.dataStore.storeData(valueData);
        NativeValue nv = isOwnValue ? (NativeValue)value : this.getNativeValue(value);
        nv.setInternalID(id2, this.revision);
        this.valueIDCache.put(nv, new Integer(id2));
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        try {
            Lock writeLock = this.lockManager.getWriteLock();
            try {
                this.dataStore.clear();
                this.valueCache.clear();
                this.valueIDCache.clear();
                this.namespaceCache.clear();
                this.namespaceIDCache.clear();
                this.initBNodeParams();
                this.setNewRevision();
            }
            finally {
                writeLock.release();
            }
        }
        catch (InterruptedException e2) {
            IOException ioe = new IOException("Failed to acquire write lock");
            ioe.initCause(e2);
            throw ioe;
        }
    }

    public void sync() throws IOException {
        this.dataStore.sync();
    }

    public void close() throws IOException {
        this.dataStore.close();
    }

    private boolean isOwnValue(Value value) {
        return value instanceof NativeValue && ((NativeValue)value).getValueStoreRevision().getValueStore() == this;
    }

    private boolean revisionIsCurrent(NativeValue value) {
        return this.revision.equals(value.getValueStoreRevision());
    }

    private byte[] value2data(Value value, boolean create) throws IOException {
        if (value instanceof URI) {
            return this.uri2data((URI)value, create);
        }
        if (value instanceof BNode) {
            return this.bnode2data((BNode)value, create);
        }
        if (value instanceof Literal) {
            return this.literal2data((Literal)value, create);
        }
        throw new IllegalArgumentException("value parameter should be a URI, BNode or Literal");
    }

    private byte[] uri2data(URI uri, boolean create) throws IOException {
        int nsID = this.getNamespaceID(uri.getNamespace(), create);
        if (nsID == -1) {
            return null;
        }
        byte[] localNameData = uri.getLocalName().getBytes("UTF-8");
        byte[] uriData = new byte[5 + localNameData.length];
        uriData[0] = 1;
        ByteArrayUtil.putInt(nsID, uriData, 1);
        ByteArrayUtil.put(localNameData, uriData, 5);
        return uriData;
    }

    private byte[] bnode2data(BNode bNode, boolean create) throws IOException {
        byte[] idData = bNode.getID().getBytes("UTF-8");
        byte[] bNodeData = new byte[1 + idData.length];
        bNodeData[0] = 2;
        ByteArrayUtil.put(idData, bNodeData, 1);
        return bNodeData;
    }

    private byte[] literal2data(Literal literal, boolean create) throws IOException {
        int datatypeID = -1;
        if (literal.getDatatype() != null) {
            if (create) {
                datatypeID = this.storeValue(literal.getDatatype());
            } else {
                datatypeID = this.getID(literal.getDatatype());
                if (datatypeID == -1) {
                    return null;
                }
            }
        }
        byte[] langData = null;
        int langDataLength = 0;
        if (literal.getLanguage() != null) {
            langData = literal.getLanguage().getBytes("UTF-8");
            langDataLength = langData.length;
        }
        byte[] labelData = literal.getLabel().getBytes("UTF-8");
        byte[] literalData = new byte[6 + langDataLength + labelData.length];
        literalData[0] = 3;
        ByteArrayUtil.putInt(datatypeID, literalData, 1);
        literalData[5] = (byte)langDataLength;
        if (langData != null) {
            ByteArrayUtil.put(langData, literalData, 6);
        }
        ByteArrayUtil.put(labelData, literalData, 6 + langDataLength);
        return literalData;
    }

    private NativeValue data2value(int id, byte[] data) throws IOException {
        switch (data[0] & 3) {
            case 1: {
                return this.data2uri(id, data);
            }
            case 2: {
                return this.data2bnode(id, data);
            }
            case 3: {
                return this.data2literal(id, data);
            }
        }
        throw new IllegalArgumentException("data does not specify a known value type");
    }

    private NativeURI data2uri(int id, byte[] data) throws IOException {
        int nsID = ByteArrayUtil.getInt(data, 1);
        String namespace2 = this.getNamespace(nsID);
        String localName = new String(data, 5, data.length - 5, "UTF-8");
        return new NativeURI(this.revision, namespace2, localName, id);
    }

    private NativeBNode data2bnode(int id, byte[] data) throws IOException {
        String nodeID = new String(data, 1, data.length - 1, "UTF-8");
        return new NativeBNode(this.revision, nodeID, id);
    }

    private NativeLiteral data2literal(int id, byte[] data) throws IOException {
        int datatypeID = ByteArrayUtil.getInt(data, 1);
        URI datatype = null;
        if (datatypeID != -1) {
            datatype = (URI)((Object)this.getValue(datatypeID));
        }
        String lang = null;
        byte langLength = data[5];
        if (langLength > 0) {
            lang = new String(data, 6, (int)langLength, "UTF-8");
        }
        String label = new String(data, 6 + langLength, data.length - 6 - langLength, "UTF-8");
        if (datatype != null) {
            return new NativeLiteral(this.revision, label, datatype, id);
        }
        if (lang != null) {
            return new NativeLiteral(this.revision, label, lang, id);
        }
        return new NativeLiteral(this.revision, label, id);
    }

    private int getNamespaceID(String namespace2, boolean create) throws IOException {
        Integer cacheID = this.namespaceIDCache.get(namespace2);
        if (cacheID != null) {
            return cacheID;
        }
        byte[] namespaceData = namespace2.getBytes("UTF-8");
        int id = create ? this.dataStore.storeData(namespaceData) : this.dataStore.getID(namespaceData);
        if (id != -1) {
            this.namespaceIDCache.put(namespace2, new Integer(id));
        }
        return id;
    }

    private String getNamespace(int id) throws IOException {
        Integer cacheID = new Integer(id);
        String namespace2 = this.namespaceCache.get(cacheID);
        if (namespace2 == null) {
            byte[] namespaceData = this.dataStore.getData(id);
            namespace2 = new String(namespaceData, "UTF-8");
            this.namespaceCache.put(cacheID, namespace2);
        }
        return namespace2;
    }

    public NativeURI createURI(String uri) {
        return new NativeURI(this.revision, uri);
    }

    public NativeURI createURI(String namespace2, String localName) {
        return new NativeURI(this.revision, namespace2, localName);
    }

    public NativeBNode createBNode(String nodeID) {
        return new NativeBNode(this.revision, nodeID);
    }

    public NativeLiteral createLiteral(String value) {
        return new NativeLiteral(this.revision, value);
    }

    public NativeLiteral createLiteral(String value, String language) {
        return new NativeLiteral(this.revision, value, language);
    }

    public NativeLiteral createLiteral(String value, URI datatype) {
        return new NativeLiteral(this.revision, value, datatype);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        return new ContextStatementImpl(subject, predicate, object, context);
    }

    public NativeValue getNativeValue(Value value) {
        if (value instanceof Resource) {
            return this.getNativeResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getNativeLiteral((Literal)value);
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass());
    }

    public NativeResource getNativeResource(Resource resource) {
        if (resource instanceof URI) {
            return this.getNativeURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.getNativeBNode((BNode)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
    }

    public NativeURI getNativeURI(URI uri) {
        if (this.isOwnValue(uri)) {
            return (NativeURI)uri;
        }
        return new NativeURI(this.revision, ((Object)uri).toString());
    }

    public NativeBNode getNativeBNode(BNode bnode2) {
        if (this.isOwnValue(bnode2)) {
            return (NativeBNode)bnode2;
        }
        return new NativeBNode(this.revision, bnode2.getID());
    }

    public NativeLiteral getNativeLiteral(Literal l) {
        if (this.isOwnValue(l)) {
            return (NativeLiteral)l;
        }
        if (l.getLanguage() != null) {
            return new NativeLiteral(this.revision, l.getLabel(), l.getLanguage());
        }
        if (l.getDatatype() != null) {
            NativeURI datatype = this.getNativeURI(l.getDatatype());
            return new NativeLiteral(this.revision, l.getLabel(), datatype);
        }
        return new NativeLiteral(this.revision, l.getLabel());
    }

    public static void main(String[] args) throws Exception {
        File dataDir = new File(args[0]);
        ValueStore valueStore = new ValueStore(dataDir);
        int maxID = valueStore.dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            NativeValue value = valueStore.getValue(id);
            System.out.println("[" + id + "] " + value.toString());
        }
    }
}

