/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iterations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.nativerdf.NativeEvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeTripleSource;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStoreConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    protected final NativeStore nativeStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;

    protected NativeStoreConnection(NativeStore nativeStore) throws IOException {
        super(nativeStore);
        this.nativeStore = nativeStore;
        this.sailChangedEvent = new DefaultSailChangedEvent(nativeStore);
    }

    @Override
    protected void closeInternal() {
    }

    @Override
    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings2, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming query model:\n{}", tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        try {
            this.replaceValues(tupleExpr);
            NativeTripleSource tripleSource = new NativeTripleSource(this.nativeStore, includeInferred, this.transactionActive());
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl(tripleSource, dataset);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings2);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings2);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings2);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings2);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings2);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings2);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings2);
            new QueryJoinOptimizer(new NativeEvaluationStatistics(this.nativeStore)).optimize(tupleExpr, dataset, bindings2);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings2);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings2);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings2);
            this.logger.trace("Optimized query model:\n{}", tupleExpr);
            return strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
        }
        catch (QueryEvaluationException e2) {
            throw new SailException(e2);
        }
    }

    protected void replaceValues(TupleExpr tupleExpr) throws SailException {
        tupleExpr.visit(new QueryModelVisitorBase<SailException>(){

            @Override
            public void meet(Var var) {
                if (var.hasValue()) {
                    var.setValue(NativeStoreConnection.this.nativeStore.getValueStore().getNativeValue(var.getValue()));
                }
            }
        });
    }

    @Override
    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        try {
            CloseableIteration<Resource, IOException> contextIter = this.nativeStore.getContextIDs(this.transactionActive());
            return new ExceptionConvertingIteration<Resource, SailException>(contextIter){

                @Override
                protected SailException convert(Exception e2) {
                    if (e2 instanceof IOException) {
                        return new SailException(e2);
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e2.getClass());
                }
            };
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }

    @Override
    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try {
            CloseableIteration<? extends Statement, IOException> iter = this.nativeStore.createStatementIterator(subj, pred, obj, includeInferred, this.transactionActive(), contexts);
            return new ExceptionConvertingIteration<Statement, SailException>(iter){

                @Override
                protected SailException convert(Exception e2) {
                    if (e2 instanceof IOException) {
                        return new SailException(e2);
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e2.getClass());
                }
            };
        }
        catch (IOException e2) {
            throw new SailException("Unable to get statements", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long sizeInternal(Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        try {
            List<Integer> contextIDs = contexts.length == 0 ? Arrays.asList(-1) : this.nativeStore.getContextIDs(contexts);
            long size = 0L;
            for (int contextID : contextIDs) {
                RecordIterator iter = this.nativeStore.getTripleStore().getTriples(-1, -1, -1, contextID, true, this.transactionActive());
                try {
                    while (iter.next() != null) {
                        ++size;
                    }
                }
                finally {
                    iter.close();
                }
            }
            return size;
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }

    @Override
    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return new CloseableIteratorIteration<NamespaceImpl, SailException>(this.nativeStore.getNamespaceStore().iterator());
    }

    @Override
    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.nativeStore.getNamespaceStore().getNamespace(prefix);
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        this.txnLock = this.nativeStore.getTransactionLock();
        boolean relaseLock = true;
        try {
            this.nativeStore.getTripleStore().startTransaction();
            relaseLock = false;
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        finally {
            if (relaseLock) {
                this.txnLock.release();
            }
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        try {
            this.nativeStore.getValueStore().sync();
            this.nativeStore.getNamespaceStore().sync();
            this.nativeStore.getTripleStore().commit();
            this.txnLock.release();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        catch (RuntimeException e3) {
            this.logger.error("Encountered an unexpected problem while trying to commit", e3);
            throw e3;
        }
        this.nativeStore.notifySailChanged(this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent(this.nativeStore);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        try {
            this.nativeStore.getValueStore().sync();
            this.nativeStore.getTripleStore().rollback();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        catch (RuntimeException e3) {
            this.logger.error("Encountered an unexpected problem while trying to roll back", e3);
            throw e3;
        }
        finally {
            this.txnLock.release();
        }
    }

    @Override
    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatement(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                boolean bl = this.addStatement(subj, pred, obj, false, contexts);
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    private boolean addStatement(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean result = false;
        try {
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = valueStore.storeValue(subj);
            int predID = valueStore.storeValue(pred);
            int objID = valueStore.storeValue(obj);
            if (contexts.length == 0) {
                contexts = new Resource[]{null};
            }
            for (Resource context : contexts) {
                int contextID = 0;
                if (context != null) {
                    contextID = valueStore.storeValue(context);
                }
                boolean wasNew = this.nativeStore.getTripleStore().storeTriple(subjID, predID, objID, contextID, explicit);
                result |= wasNew;
                if (!wasNew) continue;
                this.sailChangedEvent.setStatementsAdded(true);
                if (!this.hasConnectionListeners()) continue;
                Statement st = context != null ? valueStore.createStatement(subj, pred, obj, context) : valueStore.createStatement(subj, pred, obj);
                this.notifyStatementAdded(st);
            }
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        catch (RuntimeException e3) {
            this.logger.error("Encountered an unexpected problem while trying to add a statement", e3);
            throw e3;
        }
        return result;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.removeStatements(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                int removeCount = this.removeStatements(subj, pred, obj, false, contexts);
                boolean bl = removeCount > 0;
                this.updateLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    private int removeStatements(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        try {
            TripleStore tripleStore = this.nativeStore.getTripleStore();
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = -1;
            if (subj != null && (subjID = valueStore.getID(subj)) == -1) {
                return 0;
            }
            int predID = -1;
            if (pred != null && (predID = valueStore.getID(pred)) == -1) {
                return 0;
            }
            int objID = -1;
            if (obj != null && (objID = valueStore.getID(obj)) == -1) {
                return 0;
            }
            ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
            if (contexts.length == 0) {
                contextIDList.add(-1);
            } else {
                for (Resource context : contexts) {
                    if (context == null) {
                        contextIDList.add(0);
                        continue;
                    }
                    int contextID = valueStore.getID(context);
                    if (contextID == -1) continue;
                    contextIDList.add(contextID);
                }
            }
            int removeCount = 0;
            for (int i = 0; i < contextIDList.size(); ++i) {
                int contextID = (Integer)contextIDList.get(i);
                List<Object> removedStatements = Collections.emptyList();
                if (this.hasConnectionListeners()) {
                    RecordIterator btreeIter = tripleStore.getTriples(subjID, predID, objID, contextID, explicit, true);
                    NativeStatementIterator iter = new NativeStatementIterator(btreeIter, valueStore);
                    removedStatements = Iterations.asList(iter);
                }
                removeCount += tripleStore.removeTriples(subjID, predID, objID, contextID, explicit);
                for (Statement st : removedStatements) {
                    this.notifyStatementRemoved(st);
                }
            }
            if (removeCount > 0) {
                this.sailChangedEvent.setStatementsRemoved(true);
            }
            return removeCount;
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        catch (RuntimeException e3) {
            this.logger.error("Encountered an unexpected problem while trying to remove statements", e3);
            throw e3;
        }
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatements(null, null, null, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.removeStatements(null, null, null, false, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public void flushUpdates() {
    }

    @Override
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.nativeStore.getNamespaceStore().setNamespace(prefix, name);
    }

    @Override
    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.nativeStore.getNamespaceStore().removeNamespace(prefix);
    }

    @Override
    protected void clearNamespacesInternal() throws SailException {
        this.nativeStore.getNamespaceStore().clear();
    }
}

