/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryBase;
import org.openrdf.model.util.URIUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.memory.model.BooleanMemLiteral;
import org.openrdf.sail.memory.model.CalendarMemLiteral;
import org.openrdf.sail.memory.model.DecimalMemLiteral;
import org.openrdf.sail.memory.model.IntegerMemLiteral;
import org.openrdf.sail.memory.model.MemBNode;
import org.openrdf.sail.memory.model.MemLiteral;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.NumericMemLiteral;
import org.openrdf.sail.memory.model.WeakObjectRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemValueFactory
extends ValueFactoryBase {
    private final WeakObjectRegistry<MemURI> uriRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemBNode> bnodeRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemLiteral> literalRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<String> namespaceRegistry = new WeakObjectRegistry();

    public void clear() {
        this.uriRegistry.clear();
        this.bnodeRegistry.clear();
        this.literalRegistry.clear();
        this.namespaceRegistry.clear();
    }

    public MemValue getMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getMemLiteral((Literal)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getMemResource(Resource resource) {
        if (resource instanceof URI) {
            return this.getMemURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.getMemBNode((BNode)resource);
        }
        if (resource == null) {
            return null;
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemURI getMemURI(URI uri) {
        if (this.isOwnMemValue(uri)) {
            return (MemURI)uri;
        }
        return this.uriRegistry.get(uri);
    }

    public synchronized MemBNode getMemBNode(BNode bnode2) {
        if (this.isOwnMemValue(bnode2)) {
            return (MemBNode)bnode2;
        }
        return this.bnodeRegistry.get(bnode2);
    }

    public synchronized MemLiteral getMemLiteral(Literal literal) {
        if (this.isOwnMemValue(literal)) {
            return (MemLiteral)literal;
        }
        return this.literalRegistry.get(literal);
    }

    private boolean isOwnMemValue(Value value) {
        return value instanceof MemValue && ((MemValue)value).getCreator() == this;
    }

    public Set<MemURI> getMemURIs() {
        return Collections.unmodifiableSet(this.uriRegistry);
    }

    public Set<MemBNode> getMemBNodes() {
        return Collections.unmodifiableSet(this.bnodeRegistry);
    }

    public Set<MemLiteral> getMemLiterals() {
        return Collections.unmodifiableSet(this.literalRegistry);
    }

    public MemValue getOrCreateMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getOrCreateMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getOrCreateMemLiteral((Literal)value);
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getOrCreateMemResource(Resource resource) {
        if (resource instanceof URI) {
            return this.getOrCreateMemURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.getOrCreateMemBNode((BNode)resource);
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemURI getOrCreateMemURI(URI uri) {
        MemURI memURI = this.getMemURI(uri);
        if (memURI == null) {
            String namespace2 = uri.getNamespace();
            String sharedNamespace = this.namespaceRegistry.get(namespace2);
            if (sharedNamespace == null) {
                this.namespaceRegistry.add(namespace2);
            } else {
                namespace2 = sharedNamespace;
            }
            memURI = new MemURI(this, namespace2, uri.getLocalName());
            boolean wasNew = this.uriRegistry.add(memURI);
            assert (wasNew) : "Created a duplicate MemURI for URI " + uri;
        }
        return memURI;
    }

    public synchronized MemBNode getOrCreateMemBNode(BNode bnode2) {
        MemBNode memBNode = this.getMemBNode(bnode2);
        if (memBNode == null) {
            memBNode = new MemBNode(this, bnode2.getID());
            boolean wasNew = this.bnodeRegistry.add(memBNode);
            assert (wasNew) : "Created a duplicate MemBNode for bnode " + bnode2;
        }
        return memBNode;
    }

    public synchronized MemLiteral getOrCreateMemLiteral(Literal literal) {
        MemLiteral memLiteral = this.getMemLiteral(literal);
        if (memLiteral == null) {
            block12: {
                String label = literal.getLabel();
                URI datatype = literal.getDatatype();
                if (datatype != null) {
                    try {
                        if (XMLDatatypeUtil.isIntegerDatatype(datatype)) {
                            memLiteral = new IntegerMemLiteral(this, label, literal.integerValue(), datatype);
                            break block12;
                        }
                        if (((Object)datatype).equals(XMLSchema.DECIMAL)) {
                            memLiteral = new DecimalMemLiteral(this, label, literal.decimalValue(), datatype);
                            break block12;
                        }
                        if (((Object)datatype).equals(XMLSchema.FLOAT)) {
                            memLiteral = new NumericMemLiteral(this, label, Float.valueOf(literal.floatValue()), datatype);
                            break block12;
                        }
                        if (((Object)datatype).equals(XMLSchema.DOUBLE)) {
                            memLiteral = new NumericMemLiteral(this, label, literal.doubleValue(), datatype);
                            break block12;
                        }
                        if (((Object)datatype).equals(XMLSchema.BOOLEAN)) {
                            memLiteral = new BooleanMemLiteral((Object)this, label, literal.booleanValue());
                            break block12;
                        }
                        if (((Object)datatype).equals(XMLSchema.DATETIME)) {
                            memLiteral = new CalendarMemLiteral(this, label, datatype, literal.calendarValue());
                            break block12;
                        }
                        memLiteral = new MemLiteral((Object)this, label, datatype);
                    }
                    catch (IllegalArgumentException e2) {
                        memLiteral = new MemLiteral((Object)this, label, datatype);
                    }
                } else {
                    memLiteral = literal.getLanguage() != null ? new MemLiteral((Object)this, label, literal.getLanguage()) : new MemLiteral(this, label);
                }
            }
            boolean wasNew = this.literalRegistry.add(memLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + literal;
        }
        return memLiteral;
    }

    @Override
    public synchronized URI createURI(String uri) {
        URIImpl tempURI = new URIImpl(uri);
        return this.getOrCreateMemURI(tempURI);
    }

    @Override
    public synchronized URI createURI(String namespace2, String localName) {
        URI tempURI = null;
        if (URIUtil.isCorrectURISplit(namespace2, localName)) {
            if (namespace2.indexOf(58) == -1) {
                throw new IllegalArgumentException("Not a valid (absolute) URI: " + namespace2 + localName);
            }
            tempURI = new MemURI(null, namespace2, localName);
        } else {
            tempURI = new URIImpl(namespace2 + localName);
        }
        return this.getOrCreateMemURI(tempURI);
    }

    @Override
    public synchronized BNode createBNode(String nodeID) {
        BNodeImpl tempBNode = new BNodeImpl(nodeID);
        return this.getOrCreateMemBNode(tempBNode);
    }

    @Override
    public synchronized Literal createLiteral(String value) {
        LiteralImpl tempLiteral = new LiteralImpl(value);
        return this.getOrCreateMemLiteral(tempLiteral);
    }

    @Override
    public synchronized Literal createLiteral(String value, String language) {
        LiteralImpl tempLiteral = new LiteralImpl(value, language);
        return this.getOrCreateMemLiteral(tempLiteral);
    }

    @Override
    public synchronized Literal createLiteral(String value, URI datatype) {
        LiteralImpl tempLiteral = new LiteralImpl(value, datatype);
        return this.getOrCreateMemLiteral(tempLiteral);
    }

    @Override
    public synchronized Literal createLiteral(boolean value) {
        BooleanMemLiteral newLiteral = new BooleanMemLiteral((Object)this, value);
        return this.getSharedLiteral(newLiteral);
    }

    @Override
    protected synchronized Literal createIntegerLiteral(Number n, URI datatype) {
        IntegerMemLiteral newLiteral = new IntegerMemLiteral((Object)this, BigInteger.valueOf(n.longValue()), datatype);
        return this.getSharedLiteral(newLiteral);
    }

    @Override
    protected synchronized Literal createFPLiteral(Number n, URI datatype) {
        NumericMemLiteral newLiteral = new NumericMemLiteral((Object)this, n, datatype);
        return this.getSharedLiteral(newLiteral);
    }

    @Override
    public synchronized Literal createLiteral(XMLGregorianCalendar calendar) {
        CalendarMemLiteral newLiteral = new CalendarMemLiteral((Object)this, calendar);
        return this.getSharedLiteral(newLiteral);
    }

    private Literal getSharedLiteral(MemLiteral newLiteral) {
        MemLiteral sharedLiteral = this.literalRegistry.get(newLiteral);
        if (sharedLiteral == null) {
            boolean wasNew = this.literalRegistry.add(newLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + newLiteral;
            sharedLiteral = newLiteral;
        }
        return sharedLiteral;
    }

    @Override
    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    @Override
    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        if (context == null) {
            return new StatementImpl(subject, predicate, object);
        }
        return new ContextStatementImpl(subject, predicate, object, context);
    }
}

