/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.trig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.turtle.TurtleWriter;

public class TriGWriter
extends TurtleWriter {
    private boolean inActiveContext;
    private Resource currentContext;

    public TriGWriter(OutputStream out) {
        super(out);
    }

    public TriGWriter(Writer writer) {
        super(writer);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIG;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.inActiveContext = false;
        this.currentContext = null;
    }

    public void endRDF() throws RDFHandlerException {
        super.endRDF();
        try {
            this.closeActiveContext();
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !TriGWriter.contextsEquals(context, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
            }
            if (!this.inActiveContext) {
                this.writer.writeEOL();
                if (context != null) {
                    this.writeResource(context);
                    this.writer.write(" ");
                }
                this.writer.write("{");
                this.writer.increaseIndentation();
                this.currentContext = context;
                this.inActiveContext = true;
            }
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
        super.handleStatement(st);
    }

    protected void writeCommentLine(String line) throws IOException {
        this.closeActiveContext();
        super.writeCommentLine(line);
    }

    protected void writeNamespace(String prefix, String name) throws IOException {
        this.closeActiveContext();
        super.writeNamespace(prefix, name);
    }

    protected void closeActiveContext() throws IOException {
        if (this.inActiveContext) {
            this.writer.decreaseIndentation();
            this.writer.write("}");
            this.writer.writeEOL();
            this.inActiveContext = false;
            this.currentContext = null;
        }
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

