/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailTupleQuery
extends SailQuery
implements TupleQuery {
    protected SailTupleQuery(ParsedTupleQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super(tupleQuery, sailConnection);
    }

    public ParsedTupleQuery getParsedQuery() {
        return (ParsedTupleQuery)super.getParsedQuery();
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            return new TupleQueryResultImpl(new ArrayList<String>(tupleExpr.getBindingNames()), bindingsIter);
        }
        catch (SailException e2) {
            throw new QueryEvaluationException(e2.getMessage(), e2);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResultUtil.report(queryResult, handler);
    }
}

