/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryLockedException;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailLockedException;

public class SailRepository
implements Repository {
    private final Sail sail;

    public SailRepository(Sail sail) {
        this.sail = sail;
    }

    public File getDataDir() {
        return this.sail.getDataDir();
    }

    public void setDataDir(File dataDir) {
        this.sail.setDataDir(dataDir);
    }

    public void initialize() throws RepositoryException {
        try {
            this.sail.initialize();
        }
        catch (SailLockedException e2) {
            String l = e2.getLockedBy();
            String r = e2.getRequestedBy();
            String m = e2.getMessage();
            throw new RepositoryLockedException(l, r, m, e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3.getMessage(), e3);
        }
    }

    public void shutDown() throws RepositoryException {
        try {
            this.sail.shutDown();
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to shutdown Sail", e2);
        }
    }

    public Sail getSail() {
        return this.sail;
    }

    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to determine writable status of Sail", e2);
        }
    }

    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    public SailRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new SailRepositoryConnection(this, this.sail.getConnection());
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    public String toString() {
        return this.sail.toString();
    }
}

