/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import org.openrdf.repository.http.config.HTTPRepositorySchema;

public class HTTPRepositoryConfig
extends RepositoryImplConfigBase {
    private String url;
    private String username;
    private String password;

    public HTTPRepositoryConfig() {
        super("openrdf:HTTPRepository");
    }

    public HTTPRepositoryConfig(String url) {
        this();
        this.setURL(url);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.url == null) {
            throw new RepositoryConfigException("No URL specified for HTTP repository");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.url != null) {
            graph.add(implNode, HTTPRepositorySchema.REPOSITORYURL, graph.getValueFactory().createURI(this.url), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal password;
            Literal username;
            URI uri = GraphUtil.getOptionalObjectURI(graph, implNode, HTTPRepositorySchema.REPOSITORYURL);
            if (uri != null) {
                this.setURL(((Object)uri).toString());
            }
            if ((username = GraphUtil.getOptionalObjectLiteral(graph, implNode, HTTPRepositorySchema.USERNAME)) != null) {
                this.setUsername(username.getLabel());
            }
            if ((password = GraphUtil.getOptionalObjectLiteral(graph, implNode, HTTPRepositorySchema.PASSWORD)) != null) {
                this.setPassword(password.getLabel());
            }
        }
        catch (GraphUtilException e2) {
            throw new RepositoryConfigException(e2.getMessage(), e2);
        }
    }
}

