/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import java.util.Iterator;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.AbstractUpdate;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractUpdate {
    protected final HTTPRepositoryConnection httpCon;
    protected final QueryLanguage queryLanguage;
    protected final String queryString;
    protected final String baseURI;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        this.httpCon = con;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
    }

    protected Binding[] getBindingsArray() {
        BindingSet bindings2 = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings2.size()];
        Iterator<Binding> iter = bindings2.iterator();
        for (int i = 0; i < bindings2.size(); ++i) {
            bindingsArray[i] = iter.next();
        }
        return bindingsArray;
    }

    public String toString() {
        return this.queryString;
    }

    public void execute() throws UpdateExecutionException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            client.sendUpdate(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getBindingsArray());
        }
        catch (UnauthorizedException e2) {
            throw new HTTPUpdateExecutionException(e2.getMessage(), e2);
        }
        catch (QueryInterruptedException e3) {
            throw new HTTPUpdateExecutionException(e3.getMessage(), e3);
        }
        catch (RepositoryException e4) {
            throw new HTTPUpdateExecutionException(e4.getMessage(), e4);
        }
        catch (MalformedQueryException e5) {
            throw new HTTPUpdateExecutionException(e5.getMessage(), e5);
        }
        catch (IOException e6) {
            throw new HTTPUpdateExecutionException(e6.getMessage(), e6);
        }
    }
}

