/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.dataset;

import java.net.MalformedURLException;
import java.net.URL;
import org.openrdf.model.URI;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryConnectionWrapper;
import org.openrdf.repository.dataset.DatasetBooleanQuery;
import org.openrdf.repository.dataset.DatasetGraphQuery;
import org.openrdf.repository.dataset.DatasetRepository;
import org.openrdf.repository.dataset.DatasetTupleQuery;
import org.openrdf.repository.sail.SailBooleanQuery;
import org.openrdf.repository.sail.SailGraphQuery;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.repository.sail.SailTupleQuery;

public class DatasetRepositoryConnection
extends RepositoryConnectionWrapper {
    private DatasetRepository repository;
    private SailRepositoryConnection delegate;

    public DatasetRepositoryConnection(DatasetRepository repository, SailRepositoryConnection delegate) {
        super(repository, delegate);
        this.repository = repository;
        this.delegate = delegate;
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query2, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareBooleanQuery(ql, query2, baseURI));
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query2, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareGraphQuery(ql, query2, baseURI));
    }

    public Query prepareQuery(QueryLanguage ql, String query2, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareQuery(ql, query2, baseURI));
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query2, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.wrap(this.delegate.prepareTupleQuery(ql, query2, baseURI));
    }

    void loadDataset(Dataset datasets) throws QueryEvaluationException {
        try {
            if (datasets == null) {
                return;
            }
            for (URI dataset : datasets.getDefaultGraphs()) {
                this.repository.loadDataset(new URL(((Object)dataset).toString()), dataset);
            }
            for (URI dataset : datasets.getNamedGraphs()) {
                this.repository.loadDataset(new URL(((Object)dataset).toString()), dataset);
            }
        }
        catch (MalformedURLException e2) {
            throw new QueryEvaluationException(e2);
        }
        catch (RepositoryException e3) {
            throw new QueryEvaluationException(e3);
        }
    }

    private Query wrap(SailQuery q) {
        if (q instanceof SailBooleanQuery) {
            return this.wrap((SailBooleanQuery)q);
        }
        if (q instanceof SailGraphQuery) {
            return this.wrap((SailGraphQuery)q);
        }
        if (q instanceof SailTupleQuery) {
            return this.wrap((SailTupleQuery)q);
        }
        throw new IllegalArgumentException(q.getClass().getSimpleName() + " not supported on DatasetRepository");
    }

    private BooleanQuery wrap(SailBooleanQuery q) {
        return new DatasetBooleanQuery(this, q);
    }

    private GraphQuery wrap(SailGraphQuery q) {
        return new DatasetGraphQuery(this, q);
    }

    private TupleQuery wrap(SailTupleQuery q) {
        return new DatasetTupleQuery(this, q);
    }
}

