/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLResultsCSVWriter
implements TupleQueryResultWriter {
    private Writer writer;
    private List<String> bindingNames;

    public SPARQLResultsCSVWriter(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(w, 1024);
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this.writeURI((URI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(URI uri) throws IOException {
        String uriString = ((Object)uri).toString();
        this.writer.write(uriString);
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        URI datatype = literal.getDatatype();
        String language = literal.getLanguage();
        boolean quoted = false;
        if (datatype != null || language != null || label.contains("\"") || label.contains(",") || label.contains("\r") || label.contains("\n")) {
            quoted = true;
            label = label.replaceAll("\"", "\"\"");
            label = "\"\"" + label + "\"\"";
        }
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(label);
        if (datatype != null) {
            this.writer.write("^^");
            this.writeURI(datatype);
        } else if (language != null) {
            this.writer.write("@");
            this.writer.write(language);
        }
        if (quoted) {
            this.writer.write("\"");
        }
    }
}

