/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.dawg;

import org.openrdf.model.Graph;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.dawg.DAWGTestBooleanParser;
import org.openrdf.query.dawg.DAWGTestResultSetParseException;
import org.openrdf.query.dawg.DAWGTestResultSetParser;
import org.openrdf.query.dawg.DAWGTestResultSetWriter;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAWGTestResultSetUtil {
    public static TupleQueryResult toTupleQueryResult(Iterable<? extends Statement> dawgGraph) throws DAWGTestResultSetParseException {
        TupleQueryResultBuilder tqrBuilder = new TupleQueryResultBuilder();
        DAWGTestResultSetParser parser = new DAWGTestResultSetParser(tqrBuilder);
        try {
            parser.startRDF();
            for (Statement statement : dawgGraph) {
                parser.handleStatement(statement);
            }
            parser.endRDF();
            return tqrBuilder.getQueryResult();
        }
        catch (RDFHandlerException e2) {
            throw new DAWGTestResultSetParseException(e2.getMessage(), e2);
        }
    }

    public static Graph toGraph(TupleQueryResult tqr) throws QueryEvaluationException {
        GraphImpl graph = new GraphImpl();
        DAWGTestResultSetWriter writer = new DAWGTestResultSetWriter(new StatementCollector(graph));
        try {
            writer.startQueryResult(tqr.getBindingNames());
            while (tqr.hasNext()) {
                writer.handleSolution((BindingSet)tqr.next());
            }
            writer.endQueryResult();
        }
        catch (TupleQueryResultHandlerException e2) {
            throw new RuntimeException(e2);
        }
        return graph;
    }

    public static boolean toBooleanQueryResult(Iterable<? extends Statement> dawgGraph) throws DAWGTestResultSetParseException {
        DAWGTestBooleanParser parser = new DAWGTestBooleanParser();
        try {
            parser.startRDF();
            for (Statement statement : dawgGraph) {
                parser.handleStatement(statement);
            }
            parser.endRDF();
            return parser.getValue();
        }
        catch (RDFHandlerException e2) {
            throw new DAWGTestResultSetParseException(e2.getMessage(), e2);
        }
    }
}

