/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.DecimalLiteralImpl;
import org.openrdf.model.impl.IntegerLiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

public class MathUtil {
    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype == null || !XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (rightDatatype == null || !XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        URI commonDatatype = ((Object)leftDatatype).equals(XMLSchema.DOUBLE) || ((Object)rightDatatype).equals(XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (((Object)leftDatatype).equals(XMLSchema.FLOAT) || ((Object)rightDatatype).equals(XMLSchema.FLOAT) ? XMLSchema.FLOAT : (((Object)leftDatatype).equals(XMLSchema.DECIMAL) || ((Object)rightDatatype).equals(XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? XMLSchema.DECIMAL : XMLSchema.INTEGER)));
        try {
            if (((Object)commonDatatype).equals(XMLSchema.DOUBLE)) {
                double left = leftLit.doubleValue();
                double right = rightLit.doubleValue();
                switch (op) {
                    case PLUS: {
                        return new NumericLiteralImpl(left + right);
                    }
                    case MINUS: {
                        return new NumericLiteralImpl(left - right);
                    }
                    case MULTIPLY: {
                        return new NumericLiteralImpl(left * right);
                    }
                    case DIVIDE: {
                        return new NumericLiteralImpl(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            if (((Object)commonDatatype).equals(XMLSchema.FLOAT)) {
                float left = leftLit.floatValue();
                float right = rightLit.floatValue();
                switch (op) {
                    case PLUS: {
                        return new NumericLiteralImpl(left + right);
                    }
                    case MINUS: {
                        return new NumericLiteralImpl(left - right);
                    }
                    case MULTIPLY: {
                        return new NumericLiteralImpl(left * right);
                    }
                    case DIVIDE: {
                        return new NumericLiteralImpl(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            if (((Object)commonDatatype).equals(XMLSchema.DECIMAL)) {
                BigDecimal left = leftLit.decimalValue();
                BigDecimal right = rightLit.decimalValue();
                switch (op) {
                    case PLUS: {
                        return new DecimalLiteralImpl(left.add(right));
                    }
                    case MINUS: {
                        return new DecimalLiteralImpl(left.subtract(right));
                    }
                    case MULTIPLY: {
                        return new DecimalLiteralImpl(left.multiply(right));
                    }
                    case DIVIDE: {
                        BigDecimal result = null;
                        try {
                            result = left.divide(right, MathContext.UNLIMITED);
                        }
                        catch (ArithmeticException e2) {
                            result = left.divide(right, RoundingMode.HALF_UP);
                        }
                        return new DecimalLiteralImpl(result);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            BigInteger left = leftLit.integerValue();
            BigInteger right = rightLit.integerValue();
            switch (op) {
                case PLUS: {
                    return new IntegerLiteralImpl(left.add(right));
                }
                case MINUS: {
                    return new IntegerLiteralImpl(left.subtract(right));
                }
                case MULTIPLY: {
                    return new IntegerLiteralImpl(left.multiply(right));
                }
                case DIVIDE: {
                    throw new RuntimeException("Integer divisions should be processed as decimal divisions");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
        }
        catch (NumberFormatException e3) {
            throw new ValueExprEvaluationException(e3);
        }
        catch (ArithmeticException e4) {
            throw new ValueExprEvaluationException(e4);
        }
    }
}

