/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryModelNormalizer
extends QueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings2) {
        tupleExpr.visit(this);
    }

    @Override
    public void meet(Join join) {
        super.meet(join);
        TupleExpr leftArg = join.getLeftArg();
        TupleExpr rightArg = join.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            join.replaceWith(new EmptySet());
        } else if (leftArg instanceof SingletonSet) {
            join.replaceWith(rightArg);
        } else if (rightArg instanceof SingletonSet) {
            join.replaceWith(leftArg);
        } else if (leftArg instanceof Union) {
            Union union = (Union)leftArg;
            Join leftJoin = new Join(union.getLeftArg(), rightArg.clone());
            Join rightJoin = new Join(union.getRightArg(), rightArg.clone());
            Union newUnion = new Union(leftJoin, rightJoin);
            join.replaceWith(newUnion);
            newUnion.visit(this);
        } else if (rightArg instanceof Union) {
            Union union = (Union)rightArg;
            Join leftJoin = new Join(leftArg.clone(), union.getLeftArg());
            Join rightJoin = new Join(leftArg.clone(), union.getRightArg());
            Union newUnion = new Union(leftJoin, rightJoin);
            join.replaceWith(newUnion);
            newUnion.visit(this);
        } else if (leftArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)leftArg)) {
            LeftJoin leftJoin = (LeftJoin)leftArg;
            join.replaceWith(leftJoin);
            join.setLeftArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg(join);
            leftJoin.visit(this);
        } else if (rightArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)rightArg)) {
            LeftJoin leftJoin = (LeftJoin)rightArg;
            join.replaceWith(leftJoin);
            join.setRightArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg(join);
            leftJoin.visit(this);
        }
    }

    @Override
    public void meet(LeftJoin leftJoin) {
        super.meet(leftJoin);
        TupleExpr leftArg = leftJoin.getLeftArg();
        TupleExpr rightArg = leftJoin.getRightArg();
        ValueExpr condition = leftJoin.getCondition();
        if (leftArg instanceof EmptySet) {
            leftJoin.replaceWith(leftArg);
        } else if (rightArg instanceof EmptySet) {
            leftJoin.replaceWith(leftArg);
        } else if (rightArg instanceof SingletonSet) {
            leftJoin.replaceWith(leftArg);
        } else if (condition instanceof ValueConstant) {
            boolean conditionValue;
            try {
                conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue(((ValueConstant)condition).getValue());
            }
            catch (ValueExprEvaluationException e2) {
                conditionValue = false;
            }
            if (!conditionValue) {
                leftJoin.replaceWith(leftArg);
            } else {
                leftJoin.setCondition(null);
            }
        }
    }

    @Override
    public void meet(Union union) {
        super.meet(union);
        TupleExpr leftArg = union.getLeftArg();
        TupleExpr rightArg = union.getRightArg();
        if (leftArg instanceof EmptySet) {
            union.replaceWith(rightArg);
        } else if (rightArg instanceof EmptySet) {
            union.replaceWith(leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            union.replaceWith(leftArg);
        }
    }

    @Override
    public void meet(Difference difference) {
        super.meet(difference);
        TupleExpr leftArg = difference.getLeftArg();
        TupleExpr rightArg = difference.getRightArg();
        if (leftArg instanceof EmptySet) {
            difference.replaceWith(leftArg);
        } else if (rightArg instanceof EmptySet) {
            difference.replaceWith(leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            difference.replaceWith(new EmptySet());
        }
    }

    @Override
    public void meet(Intersection intersection) {
        super.meet(intersection);
        TupleExpr leftArg = intersection.getLeftArg();
        TupleExpr rightArg = intersection.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            intersection.replaceWith(new EmptySet());
        }
    }

    @Override
    public void meet(Or or) {
        super.meet(or);
        if (or.getLeftArg().equals(or.getRightArg())) {
            or.replaceWith(or.getLeftArg());
        }
    }

    @Override
    public void meet(And and) {
        super.meet(and);
        if (and.getLeftArg().equals(and.getRightArg())) {
            and.replaceWith(and.getLeftArg());
        }
    }

    private boolean isWellDesigned(LeftJoin leftJoin) {
        QueryModelNode parent;
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit(optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit(optionalVarCollector);
        }
        Set<String> problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        if (problemVars.isEmpty()) {
            return true;
        }
        BindingCollector bindingCollector = new BindingCollector();
        QueryModelNode node = leftJoin;
        while ((parent = node.getParentNode()) != null) {
            bindingCollector.setNodeToIgnore(node);
            parent.visitChildren(bindingCollector);
            node = parent;
        }
        problemVars.retainAll(bindingCollector.getBindingNames());
        return problemVars.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindingCollector
    extends QueryModelVisitorBase<RuntimeException> {
        private QueryModelNode nodeToIgnore;
        private final Set<String> bindingNames = new HashSet<String>();

        private BindingCollector() {
        }

        public void setNodeToIgnore(QueryModelNode node) {
            this.nodeToIgnore = node;
        }

        public Set<String> getBindingNames() {
            return this.bindingNames;
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            if (node instanceof TupleExpr && node != this.nodeToIgnore) {
                TupleExpr tupleExpr = (TupleExpr)node;
                this.bindingNames.addAll(tupleExpr.getBindingNames());
            }
        }
    }
}

